<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://at.memnonnetworks.com/ws/services/ConsignmentWS?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://at.memnonnetworks.com/ws/services/ConsignmentWS?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\Lib\Unifaun\ClassMap::get(),
);
/**
 * Samples for Archive ServiceType
 */
$archive = new \App\Lib\Unifaun\ServiceType\Archive($options);
/**
 * Sample call for archive operation/method
 */
if ($archive->archive(new \App\Lib\Unifaun\StructType\Archive()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Samples for Book ServiceType
 */
$book = new \App\Lib\Unifaun\ServiceType\Book($options);
/**
 * Sample call for book operation/method
 */
if ($book->book(new \App\Lib\Unifaun\StructType\Book()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Samples for Consolidate ServiceType
 */
$consolidate = new \App\Lib\Unifaun\ServiceType\Consolidate($options);
/**
 * Sample call for consolidate operation/method
 */
if ($consolidate->consolidate(new \App\Lib\Unifaun\StructType\Consolidate()) !== false) {
    print_r($consolidate->getResult());
} else {
    print_r($consolidate->getLastError());
}
/**
 * Samples for Copy ServiceType
 */
$copy = new \App\Lib\Unifaun\ServiceType\Copy($options);
/**
 * Sample call for copy operation/method
 */
if ($copy->copy(new \App\Lib\Unifaun\StructType\Copy()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \App\Lib\Unifaun\ServiceType\Create($options);
/**
 * Sample call for create operation/method
 */
if ($create->create(new \App\Lib\Unifaun\StructType\Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \App\Lib\Unifaun\ServiceType\Delete($options);
/**
 * Sample call for delete operation/method
 */
if ($delete->delete(new \App\Lib\Unifaun\StructType\Delete()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deletePackageId operation/method
 */
if ($delete->deletePackageId(new \App\Lib\Unifaun\StructType\DeletePackageId()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \App\Lib\Unifaun\ServiceType\Find($options);
/**
 * Sample call for findByConsignmentId operation/method
 */
if ($find->findByConsignmentId(new \App\Lib\Unifaun\StructType\FindByConsignmentId()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findByConsignmentNo operation/method
 */
if ($find->findByConsignmentNo(new \App\Lib\Unifaun\StructType\FindByConsignmentNo()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findByConsignorReference operation/method
 */
if ($find->findByConsignorReference(new \App\Lib\Unifaun\StructType\FindByConsignorReference()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findById operation/method
 */
if ($find->findById(new \App\Lib\Unifaun\StructType\FindById()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findByPackageId operation/method
 */
if ($find->findByPackageId(new \App\Lib\Unifaun\StructType\FindByPackageId()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findByReference operation/method
 */
if ($find->findByReference(new \App\Lib\Unifaun\StructType\FindByReference()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findByTransactionId operation/method
 */
if ($find->findByTransactionId(new \App\Lib\Unifaun\StructType\FindByTransactionId()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \App\Lib\Unifaun\ServiceType\Get($options);
/**
 * Sample call for getTransactionId operation/method
 */
if ($get->getTransactionId(new \App\Lib\Unifaun\StructType\GetTransactionId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCalculatedPrice operation/method
 */
if ($get->getCalculatedPrice(new \App\Lib\Unifaun\StructType\GetCalculatedPrice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getConsignmentTemplates operation/method
 */
if ($get->getConsignmentTemplates(new \App\Lib\Unifaun\StructType\GetConsignmentTemplates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \App\Lib\Unifaun\ServiceType\Is($options);
/**
 * Sample call for isArchived operation/method
 */
if ($is->isArchived(new \App\Lib\Unifaun\StructType\IsArchived()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for isBooked operation/method
 */
if ($is->isBooked(new \App\Lib\Unifaun\StructType\IsBooked()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for isComplete operation/method
 */
if ($is->isComplete(new \App\Lib\Unifaun\StructType\IsComplete()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for isOrdered operation/method
 */
if ($is->isOrdered(new \App\Lib\Unifaun\StructType\IsOrdered()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for isPrintable operation/method
 */
if ($is->isPrintable(new \App\Lib\Unifaun\StructType\IsPrintable()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for isPrinted operation/method
 */
if ($is->isPrinted(new \App\Lib\Unifaun\StructType\IsPrinted()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \App\Lib\Unifaun\ServiceType\Order($options);
/**
 * Sample call for order operation/method
 */
if ($order->order(new \App\Lib\Unifaun\StructType\Order()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Print ServiceType
 */
$print = new \App\Lib\Unifaun\ServiceType\_Print($options);
/**
 * Sample call for _print_1 operation/method
 */
if ($print->_print_1(new \App\Lib\Unifaun\StructType\_print()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Sample call for printLabel operation/method
 */
if ($print->printLabel(new \App\Lib\Unifaun\StructType\PrintLabel()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Sample call for printWaybill operation/method
 */
if ($print->printWaybill(new \App\Lib\Unifaun\StructType\PrintWaybill()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \App\Lib\Unifaun\ServiceType\Save($options);
/**
 * Sample call for save operation/method
 */
if ($save->save(new \App\Lib\Unifaun\StructType\Save()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Split ServiceType
 */
$split = new \App\Lib\Unifaun\ServiceType\Split($options);
/**
 * Sample call for split operation/method
 */
if ($split->split(new \App\Lib\Unifaun\StructType\Split()) !== false) {
    print_r($split->getResult());
} else {
    print_r($split->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \App\Lib\Unifaun\ServiceType\Add($options);
/**
 * Sample call for addGoodsRow operation/method
 */
if ($add->addGoodsRow(new \App\Lib\Unifaun\StructType\AddGoodsRow()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \App\Lib\Unifaun\ServiceType\Cancel($options);
/**
 * Sample call for cancel operation/method
 */
if ($cancel->cancel(new \App\Lib\Unifaun\StructType\Cancel()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
