<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reference StructType
 * @subpackage Structs
 */
class Reference extends AbstractStructBase
{
    /**
     * The customerNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:customerNo
     * @var string
     */
    public $customerNo;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:reference
     * @var string
     */
    public $reference;
    /**
     * The accountNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:accountNo
     * @var string
     */
    public $accountNo;
    /**
     * The eanCustomerNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:eanCustomerNo
     * @var string
     */
    public $eanCustomerNo;
    /**
     * The palletRegNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:palletRegNo
     * @var string
     */
    public $palletRegNo;
    /**
     * The vatNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:vatNo
     * @var string
     */
    public $vatNo;
    /**
     * Constructor method for Reference
     * @uses Reference::setCustomerNo()
     * @uses Reference::setReference()
     * @uses Reference::setAccountNo()
     * @uses Reference::setEanCustomerNo()
     * @uses Reference::setPalletRegNo()
     * @uses Reference::setVatNo()
     * @param string $customerNo
     * @param string $reference
     * @param string $accountNo
     * @param string $eanCustomerNo
     * @param string $palletRegNo
     * @param string $vatNo
     */
    public function __construct($customerNo = null, $reference = null, $accountNo = null, $eanCustomerNo = null, $palletRegNo = null, $vatNo = null)
    {
        $this
            ->setCustomerNo($customerNo)
            ->setReference($reference)
            ->setAccountNo($accountNo)
            ->setEanCustomerNo($eanCustomerNo)
            ->setPalletRegNo($palletRegNo)
            ->setVatNo($vatNo);
    }
    /**
     * Get customerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }
    /**
     * Set customerNo value
     * @param string $customerNo
     * @return \App\Lib\Unifaun\StructType\Reference
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNo, true), gettype($customerNo)), __LINE__);
        }
        $this->customerNo = $customerNo;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \App\Lib\Unifaun\StructType\Reference
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get accountNo value
     * @return string|null
     */
    public function getAccountNo()
    {
        return $this->accountNo;
    }
    /**
     * Set accountNo value
     * @param string $accountNo
     * @return \App\Lib\Unifaun\StructType\Reference
     */
    public function setAccountNo($accountNo = null)
    {
        // validation for constraint: string
        if (!is_null($accountNo) && !is_string($accountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNo, true), gettype($accountNo)), __LINE__);
        }
        $this->accountNo = $accountNo;
        return $this;
    }
    /**
     * Get eanCustomerNo value
     * @return string|null
     */
    public function getEanCustomerNo()
    {
        return $this->eanCustomerNo;
    }
    /**
     * Set eanCustomerNo value
     * @param string $eanCustomerNo
     * @return \App\Lib\Unifaun\StructType\Reference
     */
    public function setEanCustomerNo($eanCustomerNo = null)
    {
        // validation for constraint: string
        if (!is_null($eanCustomerNo) && !is_string($eanCustomerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eanCustomerNo, true), gettype($eanCustomerNo)), __LINE__);
        }
        $this->eanCustomerNo = $eanCustomerNo;
        return $this;
    }
    /**
     * Get palletRegNo value
     * @return string|null
     */
    public function getPalletRegNo()
    {
        return $this->palletRegNo;
    }
    /**
     * Set palletRegNo value
     * @param string $palletRegNo
     * @return \App\Lib\Unifaun\StructType\Reference
     */
    public function setPalletRegNo($palletRegNo = null)
    {
        // validation for constraint: string
        if (!is_null($palletRegNo) && !is_string($palletRegNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletRegNo, true), gettype($palletRegNo)), __LINE__);
        }
        $this->palletRegNo = $palletRegNo;
        return $this;
    }
    /**
     * Get vatNo value
     * @return string|null
     */
    public function getVatNo()
    {
        return $this->vatNo;
    }
    /**
     * Set vatNo value
     * @param string $vatNo
     * @return \App\Lib\Unifaun\StructType\Reference
     */
    public function setVatNo($vatNo = null)
    {
        // validation for constraint: string
        if (!is_null($vatNo) && !is_string($vatNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatNo, true), gettype($vatNo)), __LINE__);
        }
        $this->vatNo = $vatNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Reference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
