<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsignmentResult StructType
 * @subpackage Structs
 */
class ConsignmentResult extends AbstractStructBase
{
    /**
     * The consignments
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Consignment[]
     */
    public $consignments;
    /**
     * The errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Error[]
     */
    public $errors;
    /**
     * The documents
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Document[]
     */
    public $documents;
    /**
     * The receipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Receipt
     */
    public $receipt;
    /**
     * The statusCode
     * @var int
     */
    public $statusCode;
    /**
     * Constructor method for ConsignmentResult
     * @uses ConsignmentResult::setConsignments()
     * @uses ConsignmentResult::setErrors()
     * @uses ConsignmentResult::setDocuments()
     * @uses ConsignmentResult::setReceipt()
     * @uses ConsignmentResult::setStatusCode()
     * @param \App\Lib\Unifaun\StructType\Consignment[] $consignments
     * @param \App\Lib\Unifaun\StructType\Error[] $errors
     * @param \App\Lib\Unifaun\StructType\Document[] $documents
     * @param \App\Lib\Unifaun\StructType\Receipt $receipt
     * @param int $statusCode
     */
    public function __construct(array $consignments = array(), array $errors = array(), array $documents = array(), \App\Lib\Unifaun\StructType\Receipt $receipt = null, $statusCode = null)
    {
        $this
            ->setConsignments($consignments)
            ->setErrors($errors)
            ->setDocuments($documents)
            ->setReceipt($receipt)
            ->setStatusCode($statusCode);
    }
    /**
     * Get consignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Consignment[]|null
     */
    public function getConsignments()
    {
        return isset($this->consignments) ? $this->consignments : null;
    }
    /**
     * Set consignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Consignment[] $consignments
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setConsignments(array $consignments = array())
    {
        foreach ($consignments as $consignmentResultConsignmentsItem) {
            // validation for constraint: itemType
            if (!$consignmentResultConsignmentsItem instanceof \App\Lib\Unifaun\StructType\Consignment) {
                throw new \InvalidArgumentException(sprintf('The consignments property can only contain items of \App\Lib\Unifaun\StructType\Consignment, "%s" given', is_object($consignmentResultConsignmentsItem) ? get_class($consignmentResultConsignmentsItem) : gettype($consignmentResultConsignmentsItem)), __LINE__);
            }
        }
        if (is_null($consignments) || (is_array($consignments) && empty($consignments))) {
            unset($this->consignments);
        } else {
            $this->consignments = $consignments;
        }
        return $this;
    }
    /**
     * Add item to consignments value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Consignment $item
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function addToConsignments(\App\Lib\Unifaun\StructType\Consignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Consignment) {
            throw new \InvalidArgumentException(sprintf('The consignments property can only contain items of \App\Lib\Unifaun\StructType\Consignment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->consignments[] = $item;
        return $this;
    }
    /**
     * Get errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Error[]|null
     */
    public function getErrors()
    {
        return isset($this->errors) ? $this->errors : null;
    }
    /**
     * Set errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Error[] $errors
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setErrors(array $errors = array())
    {
        foreach ($errors as $consignmentResultErrorsItem) {
            // validation for constraint: itemType
            if (!$consignmentResultErrorsItem instanceof \App\Lib\Unifaun\StructType\Error) {
                throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \App\Lib\Unifaun\StructType\Error, "%s" given', is_object($consignmentResultErrorsItem) ? get_class($consignmentResultErrorsItem) : gettype($consignmentResultErrorsItem)), __LINE__);
            }
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->errors);
        } else {
            $this->errors = $errors;
        }
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Error $item
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function addToErrors(\App\Lib\Unifaun\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \App\Lib\Unifaun\StructType\Error, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Get documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Document[]|null
     */
    public function getDocuments()
    {
        return isset($this->documents) ? $this->documents : null;
    }
    /**
     * Set documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Document[] $documents
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setDocuments(array $documents = array())
    {
        foreach ($documents as $consignmentResultDocumentsItem) {
            // validation for constraint: itemType
            if (!$consignmentResultDocumentsItem instanceof \App\Lib\Unifaun\StructType\Document) {
                throw new \InvalidArgumentException(sprintf('The documents property can only contain items of \App\Lib\Unifaun\StructType\Document, "%s" given', is_object($consignmentResultDocumentsItem) ? get_class($consignmentResultDocumentsItem) : gettype($consignmentResultDocumentsItem)), __LINE__);
            }
        }
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->documents);
        } else {
            $this->documents = $documents;
        }
        return $this;
    }
    /**
     * Add item to documents value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Document $item
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function addToDocuments(\App\Lib\Unifaun\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The documents property can only contain items of \App\Lib\Unifaun\StructType\Document, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->documents[] = $item;
        return $this;
    }
    /**
     * Get receipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Receipt|null
     */
    public function getReceipt()
    {
        return isset($this->receipt) ? $this->receipt : null;
    }
    /**
     * Set receipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Lib\Unifaun\StructType\Receipt $receipt
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setReceipt(\App\Lib\Unifaun\StructType\Receipt $receipt = null)
    {
        if (is_null($receipt) || (is_array($receipt) && empty($receipt))) {
            unset($this->receipt);
        } else {
            $this->receipt = $receipt;
        }
        return $this;
    }
    /**
     * Get statusCode value
     * @return int|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param int $statusCode
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !is_numeric($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
