<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportProduct StructType
 * @subpackage Structs
 */
class TransportProduct extends AbstractStructBase
{
    /**
     * The mode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:mode
     * @var string
     */
    public $mode;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:code
     * @var string
     */
    public $code;
    /**
     * The PaymentInstruction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\PaymentInstruction
     */
    public $PaymentInstruction;
    /**
     * The AddService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\AddService[]
     */
    public $AddService;
    /**
     * The advice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:advice
     * @var bool
     */
    public $advice;
    /**
     * The Tod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Tod
     */
    public $Tod;
    /**
     * The Cod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Cod
     */
    public $Cod;
    /**
     * The Pickup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Pickup
     */
    public $Pickup;
    /**
     * The Delivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Delivery
     */
    public $Delivery;
    /**
     * The Transport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Transport
     */
    public $Transport;
    /**
     * The CustomsClearance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\CustomsClearance[]
     */
    public $CustomsClearance;
    /**
     * The Sortcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Sortcode
     */
    public $Sortcode;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Insurance
     */
    public $Insurance;
    /**
     * The ServiceOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\ServiceOption[]
     */
    public $ServiceOption;
    /**
     * Constructor method for TransportProduct
     * @uses TransportProduct::setMode()
     * @uses TransportProduct::setCode()
     * @uses TransportProduct::setPaymentInstruction()
     * @uses TransportProduct::setAddService()
     * @uses TransportProduct::setAdvice()
     * @uses TransportProduct::setTod()
     * @uses TransportProduct::setCod()
     * @uses TransportProduct::setPickup()
     * @uses TransportProduct::setDelivery()
     * @uses TransportProduct::setTransport()
     * @uses TransportProduct::setCustomsClearance()
     * @uses TransportProduct::setSortcode()
     * @uses TransportProduct::setInsurance()
     * @uses TransportProduct::setServiceOption()
     * @param string $mode
     * @param string $code
     * @param \App\Lib\Unifaun\StructType\PaymentInstruction $paymentInstruction
     * @param \App\Lib\Unifaun\StructType\AddService[] $addService
     * @param bool $advice
     * @param \App\Lib\Unifaun\StructType\Tod $tod
     * @param \App\Lib\Unifaun\StructType\Cod $cod
     * @param \App\Lib\Unifaun\StructType\Pickup $pickup
     * @param \App\Lib\Unifaun\StructType\Delivery $delivery
     * @param \App\Lib\Unifaun\StructType\Transport $transport
     * @param \App\Lib\Unifaun\StructType\CustomsClearance[] $customsClearance
     * @param \App\Lib\Unifaun\StructType\Sortcode $sortcode
     * @param \App\Lib\Unifaun\StructType\Insurance $insurance
     * @param \App\Lib\Unifaun\StructType\ServiceOption[] $serviceOption
     */
    public function __construct($mode = null, $code = null, \App\Lib\Unifaun\StructType\PaymentInstruction $paymentInstruction = null, array $addService = array(), $advice = null, \App\Lib\Unifaun\StructType\Tod $tod = null, \App\Lib\Unifaun\StructType\Cod $cod = null, \App\Lib\Unifaun\StructType\Pickup $pickup = null, \App\Lib\Unifaun\StructType\Delivery $delivery = null, \App\Lib\Unifaun\StructType\Transport $transport = null, array $customsClearance = array(), \App\Lib\Unifaun\StructType\Sortcode $sortcode = null, \App\Lib\Unifaun\StructType\Insurance $insurance = null, array $serviceOption = array())
    {
        $this
            ->setMode($mode)
            ->setCode($code)
            ->setPaymentInstruction($paymentInstruction)
            ->setAddService($addService)
            ->setAdvice($advice)
            ->setTod($tod)
            ->setCod($cod)
            ->setPickup($pickup)
            ->setDelivery($delivery)
            ->setTransport($transport)
            ->setCustomsClearance($customsClearance)
            ->setSortcode($sortcode)
            ->setInsurance($insurance)
            ->setServiceOption($serviceOption);
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @param string $mode
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mode)), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get PaymentInstruction value
     * @return \App\Lib\Unifaun\StructType\PaymentInstruction|null
     */
    public function getPaymentInstruction()
    {
        return $this->PaymentInstruction;
    }
    /**
     * Set PaymentInstruction value
     * @param \App\Lib\Unifaun\StructType\PaymentInstruction $paymentInstruction
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setPaymentInstruction(\App\Lib\Unifaun\StructType\PaymentInstruction $paymentInstruction = null)
    {
        $this->PaymentInstruction = $paymentInstruction;
        return $this;
    }
    /**
     * Get AddService value
     * @return \App\Lib\Unifaun\StructType\AddService[]|null
     */
    public function getAddService()
    {
        return $this->AddService;
    }
    /**
     * Set AddService value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\AddService[] $addService
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setAddService(array $addService = array())
    {
        foreach ($addService as $transportProductAddServiceItem) {
            // validation for constraint: itemType
            if (!$transportProductAddServiceItem instanceof \App\Lib\Unifaun\StructType\AddService) {
                throw new \InvalidArgumentException(sprintf('The AddService property can only contain items of \App\Lib\Unifaun\StructType\AddService, "%s" given', is_object($transportProductAddServiceItem) ? get_class($transportProductAddServiceItem) : gettype($transportProductAddServiceItem)), __LINE__);
            }
        }
        $this->AddService = $addService;
        return $this;
    }
    /**
     * Add item to AddService value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\AddService $item
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function addToAddService(\App\Lib\Unifaun\StructType\AddService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\AddService) {
            throw new \InvalidArgumentException(sprintf('The AddService property can only contain items of \App\Lib\Unifaun\StructType\AddService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddService[] = $item;
        return $this;
    }
    /**
     * Get advice value
     * @return bool|null
     */
    public function getAdvice()
    {
        return $this->advice;
    }
    /**
     * Set advice value
     * @param bool $advice
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setAdvice($advice = null)
    {
        // validation for constraint: boolean
        if (!is_null($advice) && !is_bool($advice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($advice)), __LINE__);
        }
        $this->advice = $advice;
        return $this;
    }
    /**
     * Get Tod value
     * @return \App\Lib\Unifaun\StructType\Tod|null
     */
    public function getTod()
    {
        return $this->Tod;
    }
    /**
     * Set Tod value
     * @param \App\Lib\Unifaun\StructType\Tod $tod
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setTod(\App\Lib\Unifaun\StructType\Tod $tod = null)
    {
        $this->Tod = $tod;
        return $this;
    }
    /**
     * Get Cod value
     * @return \App\Lib\Unifaun\StructType\Cod|null
     */
    public function getCod()
    {
        return $this->Cod;
    }
    /**
     * Set Cod value
     * @param \App\Lib\Unifaun\StructType\Cod $cod
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setCod(\App\Lib\Unifaun\StructType\Cod $cod = null)
    {
        $this->Cod = $cod;
        return $this;
    }
    /**
     * Get Pickup value
     * @return \App\Lib\Unifaun\StructType\Pickup|null
     */
    public function getPickup()
    {
        return $this->Pickup;
    }
    /**
     * Set Pickup value
     * @param \App\Lib\Unifaun\StructType\Pickup $pickup
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setPickup(\App\Lib\Unifaun\StructType\Pickup $pickup = null)
    {
        $this->Pickup = $pickup;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \App\Lib\Unifaun\StructType\Delivery|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \App\Lib\Unifaun\StructType\Delivery $delivery
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setDelivery(\App\Lib\Unifaun\StructType\Delivery $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get Transport value
     * @return \App\Lib\Unifaun\StructType\Transport|null
     */
    public function getTransport()
    {
        return $this->Transport;
    }
    /**
     * Set Transport value
     * @param \App\Lib\Unifaun\StructType\Transport $transport
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setTransport(\App\Lib\Unifaun\StructType\Transport $transport = null)
    {
        $this->Transport = $transport;
        return $this;
    }
    /**
     * Get CustomsClearance value
     * @return \App\Lib\Unifaun\StructType\CustomsClearance[]|null
     */
    public function getCustomsClearance()
    {
        return $this->CustomsClearance;
    }
    /**
     * Set CustomsClearance value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\CustomsClearance[] $customsClearance
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setCustomsClearance(array $customsClearance = array())
    {
        foreach ($customsClearance as $transportProductCustomsClearanceItem) {
            // validation for constraint: itemType
            if (!$transportProductCustomsClearanceItem instanceof \App\Lib\Unifaun\StructType\CustomsClearance) {
                throw new \InvalidArgumentException(sprintf('The CustomsClearance property can only contain items of \App\Lib\Unifaun\StructType\CustomsClearance, "%s" given', is_object($transportProductCustomsClearanceItem) ? get_class($transportProductCustomsClearanceItem) : gettype($transportProductCustomsClearanceItem)), __LINE__);
            }
        }
        $this->CustomsClearance = $customsClearance;
        return $this;
    }
    /**
     * Add item to CustomsClearance value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\CustomsClearance $item
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function addToCustomsClearance(\App\Lib\Unifaun\StructType\CustomsClearance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\CustomsClearance) {
            throw new \InvalidArgumentException(sprintf('The CustomsClearance property can only contain items of \App\Lib\Unifaun\StructType\CustomsClearance, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomsClearance[] = $item;
        return $this;
    }
    /**
     * Get Sortcode value
     * @return \App\Lib\Unifaun\StructType\Sortcode|null
     */
    public function getSortcode()
    {
        return $this->Sortcode;
    }
    /**
     * Set Sortcode value
     * @param \App\Lib\Unifaun\StructType\Sortcode $sortcode
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setSortcode(\App\Lib\Unifaun\StructType\Sortcode $sortcode = null)
    {
        $this->Sortcode = $sortcode;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \App\Lib\Unifaun\StructType\Insurance|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param \App\Lib\Unifaun\StructType\Insurance $insurance
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setInsurance(\App\Lib\Unifaun\StructType\Insurance $insurance = null)
    {
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get ServiceOption value
     * @return \App\Lib\Unifaun\StructType\ServiceOption[]|null
     */
    public function getServiceOption()
    {
        return $this->ServiceOption;
    }
    /**
     * Set ServiceOption value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ServiceOption[] $serviceOption
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setServiceOption(array $serviceOption = array())
    {
        foreach ($serviceOption as $transportProductServiceOptionItem) {
            // validation for constraint: itemType
            if (!$transportProductServiceOptionItem instanceof \App\Lib\Unifaun\StructType\ServiceOption) {
                throw new \InvalidArgumentException(sprintf('The ServiceOption property can only contain items of \App\Lib\Unifaun\StructType\ServiceOption, "%s" given', is_object($transportProductServiceOptionItem) ? get_class($transportProductServiceOptionItem) : gettype($transportProductServiceOptionItem)), __LINE__);
            }
        }
        $this->ServiceOption = $serviceOption;
        return $this;
    }
    /**
     * Add item to ServiceOption value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ServiceOption $item
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function addToServiceOption(\App\Lib\Unifaun\StructType\ServiceOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ServiceOption) {
            throw new \InvalidArgumentException(sprintf('The ServiceOption property can only contain items of \App\Lib\Unifaun\StructType\ServiceOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceOption[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
