<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsInvoice StructType
 * @subpackage Structs
 */
class GoodsInvoice extends AbstractStructBase
{
    /**
     * The invoiceNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:invoiceNo
     * @var string
     */
    public $invoiceNo;
    /**
     * The invoiceDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:invoiceDate
     * @var string
     */
    public $invoiceDate;
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:orderNo
     * @var string
     */
    public $orderNo;
    /**
     * The termsOfPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:termsOfPayment
     * @var string
     */
    public $termsOfPayment;
    /**
     * The discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:discount
     * @var string
     */
    public $discount;
    /**
     * The freightCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:freightCost
     * @var float
     */
    public $freightCost;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:currency
     * @var string
     */
    public $currency;
    /**
     * The InvoiceNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\InvoiceNote[]
     */
    public $InvoiceNote;
    /**
     * Constructor method for GoodsInvoice
     * @uses GoodsInvoice::setInvoiceNo()
     * @uses GoodsInvoice::setInvoiceDate()
     * @uses GoodsInvoice::setOrderNo()
     * @uses GoodsInvoice::setTermsOfPayment()
     * @uses GoodsInvoice::setDiscount()
     * @uses GoodsInvoice::setFreightCost()
     * @uses GoodsInvoice::setCurrency()
     * @uses GoodsInvoice::setInvoiceNote()
     * @param string $invoiceNo
     * @param string $invoiceDate
     * @param string $orderNo
     * @param string $termsOfPayment
     * @param string $discount
     * @param float $freightCost
     * @param string $currency
     * @param \App\Lib\Unifaun\StructType\InvoiceNote[] $invoiceNote
     */
    public function __construct($invoiceNo = null, $invoiceDate = null, $orderNo = null, $termsOfPayment = null, $discount = null, $freightCost = null, $currency = null, array $invoiceNote = array())
    {
        $this
            ->setInvoiceNo($invoiceNo)
            ->setInvoiceDate($invoiceDate)
            ->setOrderNo($orderNo)
            ->setTermsOfPayment($termsOfPayment)
            ->setDiscount($discount)
            ->setFreightCost($freightCost)
            ->setCurrency($currency)
            ->setInvoiceNote($invoiceNote);
    }
    /**
     * Get invoiceNo value
     * @return string|null
     */
    public function getInvoiceNo()
    {
        return $this->invoiceNo;
    }
    /**
     * Set invoiceNo value
     * @param string $invoiceNo
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function setInvoiceNo($invoiceNo = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNo) && !is_string($invoiceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNo)), __LINE__);
        }
        $this->invoiceNo = $invoiceNo;
        return $this;
    }
    /**
     * Get invoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }
    /**
     * Set invoiceDate value
     * @param string $invoiceDate
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceDate)), __LINE__);
        }
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get termsOfPayment value
     * @return string|null
     */
    public function getTermsOfPayment()
    {
        return $this->termsOfPayment;
    }
    /**
     * Set termsOfPayment value
     * @param string $termsOfPayment
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function setTermsOfPayment($termsOfPayment = null)
    {
        // validation for constraint: string
        if (!is_null($termsOfPayment) && !is_string($termsOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($termsOfPayment)), __LINE__);
        }
        $this->termsOfPayment = $termsOfPayment;
        return $this;
    }
    /**
     * Get discount value
     * @return string|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param string $discount
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get freightCost value
     * @return float|null
     */
    public function getFreightCost()
    {
        return $this->freightCost;
    }
    /**
     * Set freightCost value
     * @param float $freightCost
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function setFreightCost($freightCost = null)
    {
        $this->freightCost = $freightCost;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get InvoiceNote value
     * @return \App\Lib\Unifaun\StructType\InvoiceNote[]|null
     */
    public function getInvoiceNote()
    {
        return $this->InvoiceNote;
    }
    /**
     * Set InvoiceNote value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\InvoiceNote[] $invoiceNote
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function setInvoiceNote(array $invoiceNote = array())
    {
        foreach ($invoiceNote as $goodsInvoiceInvoiceNoteItem) {
            // validation for constraint: itemType
            if (!$goodsInvoiceInvoiceNoteItem instanceof \App\Lib\Unifaun\StructType\InvoiceNote) {
                throw new \InvalidArgumentException(sprintf('The InvoiceNote property can only contain items of \App\Lib\Unifaun\StructType\InvoiceNote, "%s" given', is_object($goodsInvoiceInvoiceNoteItem) ? get_class($goodsInvoiceInvoiceNoteItem) : gettype($goodsInvoiceInvoiceNoteItem)), __LINE__);
            }
        }
        $this->InvoiceNote = $invoiceNote;
        return $this;
    }
    /**
     * Add item to InvoiceNote value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\InvoiceNote $item
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public function addToInvoiceNote(\App\Lib\Unifaun\StructType\InvoiceNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\InvoiceNote) {
            throw new \InvalidArgumentException(sprintf('The InvoiceNote property can only contain items of \App\Lib\Unifaun\StructType\InvoiceNote, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InvoiceNote[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
