<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsGroupItem StructType
 * @subpackage Structs
 */
class GoodsGroupItem extends AbstractStructBase
{
    /**
     * The ContentItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\ContentItem[]
     */
    public $ContentItem;
    /**
     * The GoodsItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\GoodsItem[]
     */
    public $GoodsItem;
    /**
     * Constructor method for GoodsGroupItem
     * @uses GoodsGroupItem::setContentItem()
     * @uses GoodsGroupItem::setGoodsItem()
     * @param \App\Lib\Unifaun\StructType\ContentItem[] $contentItem
     * @param \App\Lib\Unifaun\StructType\GoodsItem[] $goodsItem
     */
    public function __construct(array $contentItem = array(), array $goodsItem = array())
    {
        $this
            ->setContentItem($contentItem)
            ->setGoodsItem($goodsItem);
    }
    /**
     * Get ContentItem value
     * @return \App\Lib\Unifaun\StructType\ContentItem[]|null
     */
    public function getContentItem()
    {
        return $this->ContentItem;
    }
    /**
     * Set ContentItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ContentItem[] $contentItem
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public function setContentItem(array $contentItem = array())
    {
        foreach ($contentItem as $goodsGroupItemContentItemItem) {
            // validation for constraint: itemType
            if (!$goodsGroupItemContentItemItem instanceof \App\Lib\Unifaun\StructType\ContentItem) {
                throw new \InvalidArgumentException(sprintf('The ContentItem property can only contain items of \App\Lib\Unifaun\StructType\ContentItem, "%s" given', is_object($goodsGroupItemContentItemItem) ? get_class($goodsGroupItemContentItemItem) : gettype($goodsGroupItemContentItemItem)), __LINE__);
            }
        }
        $this->ContentItem = $contentItem;
        return $this;
    }
    /**
     * Add item to ContentItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ContentItem $item
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public function addToContentItem(\App\Lib\Unifaun\StructType\ContentItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ContentItem) {
            throw new \InvalidArgumentException(sprintf('The ContentItem property can only contain items of \App\Lib\Unifaun\StructType\ContentItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContentItem[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \App\Lib\Unifaun\StructType\GoodsItem[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsItem[] $goodsItem
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        foreach ($goodsItem as $goodsGroupItemGoodsItemItem) {
            // validation for constraint: itemType
            if (!$goodsGroupItemGoodsItemItem instanceof \App\Lib\Unifaun\StructType\GoodsItem) {
                throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of \App\Lib\Unifaun\StructType\GoodsItem, "%s" given', is_object($goodsGroupItemGoodsItemItem) ? get_class($goodsGroupItemGoodsItemItem) : gettype($goodsGroupItemGoodsItemItem)), __LINE__);
            }
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsItem $item
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public function addToGoodsItem(\App\Lib\Unifaun\StructType\GoodsItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\GoodsItem) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of \App\Lib\Unifaun\StructType\GoodsItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
