<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceResult StructType
 * @subpackage Structs
 */
class PriceResult extends AbstractStructBase
{
    /**
     * The consignmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $consignmentNo;
    /**
     * The statusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $statusCode;
    /**
     * The consignmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $consignmentId;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The calculatedPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public $calculatedPrice;
    /**
     * Constructor method for PriceResult
     * @uses PriceResult::setConsignmentNo()
     * @uses PriceResult::setStatusCode()
     * @uses PriceResult::setConsignmentId()
     * @uses PriceResult::setDescription()
     * @uses PriceResult::setCalculatedPrice()
     * @param string $consignmentNo
     * @param string $statusCode
     * @param string $consignmentId
     * @param string $description
     * @param \App\Lib\Unifaun\StructType\CalculatedPrice $calculatedPrice
     */
    public function __construct($consignmentNo = null, $statusCode = null, $consignmentId = null, $description = null, \App\Lib\Unifaun\StructType\CalculatedPrice $calculatedPrice = null)
    {
        $this
            ->setConsignmentNo($consignmentNo)
            ->setStatusCode($statusCode)
            ->setConsignmentId($consignmentId)
            ->setDescription($description)
            ->setCalculatedPrice($calculatedPrice);
    }
    /**
     * Get consignmentNo value
     * @return string
     */
    public function getConsignmentNo()
    {
        return $this->consignmentNo;
    }
    /**
     * Set consignmentNo value
     * @param string $consignmentNo
     * @return \App\Lib\Unifaun\StructType\PriceResult
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNo, true), gettype($consignmentNo)), __LINE__);
        }
        $this->consignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get statusCode value
     * @return string
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param string $statusCode
     * @return \App\Lib\Unifaun\StructType\PriceResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get consignmentId value
     * @return string|null
     */
    public function getConsignmentId()
    {
        return $this->consignmentId;
    }
    /**
     * Set consignmentId value
     * @param string $consignmentId
     * @return \App\Lib\Unifaun\StructType\PriceResult
     */
    public function setConsignmentId($consignmentId = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentId) && !is_string($consignmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentId, true), gettype($consignmentId)), __LINE__);
        }
        $this->consignmentId = $consignmentId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \App\Lib\Unifaun\StructType\PriceResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get calculatedPrice value
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice|null
     */
    public function getCalculatedPrice()
    {
        return $this->calculatedPrice;
    }
    /**
     * Set calculatedPrice value
     * @param \App\Lib\Unifaun\StructType\CalculatedPrice $calculatedPrice
     * @return \App\Lib\Unifaun\StructType\PriceResult
     */
    public function setCalculatedPrice(\App\Lib\Unifaun\StructType\CalculatedPrice $calculatedPrice = null)
    {
        $this->calculatedPrice = $calculatedPrice;
        return $this;
    }
}
