<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOption StructType
 * @subpackage Structs
 */
class ServiceOption extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The ServiceOptionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\ServiceOptionItem[]
     */
    public $ServiceOptionItem;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $value;
    /**
     * Constructor method for ServiceOption
     * @uses ServiceOption::setType()
     * @uses ServiceOption::setServiceOptionItem()
     * @uses ServiceOption::setValue()
     * @param string $type
     * @param \App\Lib\Unifaun\StructType\ServiceOptionItem[] $serviceOptionItem
     * @param string $value
     */
    public function __construct($type = null, array $serviceOptionItem = array(), $value = null)
    {
        $this
            ->setType($type)
            ->setServiceOptionItem($serviceOptionItem)
            ->setValue($value);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get ServiceOptionItem value
     * @return \App\Lib\Unifaun\StructType\ServiceOptionItem[]|null
     */
    public function getServiceOptionItem()
    {
        return $this->ServiceOptionItem;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceOptionItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceOptionItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceOptionItemForArrayConstraintsFromSetServiceOptionItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceOptionServiceOptionItemItem) {
            // validation for constraint: itemType
            if (!$serviceOptionServiceOptionItemItem instanceof \App\Lib\Unifaun\StructType\ServiceOptionItem) {
                $invalidValues[] = is_object($serviceOptionServiceOptionItemItem) ? get_class($serviceOptionServiceOptionItemItem) : sprintf('%s(%s)', gettype($serviceOptionServiceOptionItemItem), var_export($serviceOptionServiceOptionItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceOptionItem property can only contain items of type \App\Lib\Unifaun\StructType\ServiceOptionItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceOptionItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ServiceOptionItem[] $serviceOptionItem
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public function setServiceOptionItem(array $serviceOptionItem = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceOptionItemArrayErrorMessage = self::validateServiceOptionItemForArrayConstraintsFromSetServiceOptionItem($serviceOptionItem))) {
            throw new \InvalidArgumentException($serviceOptionItemArrayErrorMessage, __LINE__);
        }
        $this->ServiceOptionItem = $serviceOptionItem;
        return $this;
    }
    /**
     * Add item to ServiceOptionItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ServiceOptionItem $item
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public function addToServiceOptionItem(\App\Lib\Unifaun\StructType\ServiceOptionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ServiceOptionItem) {
            throw new \InvalidArgumentException(sprintf('The ServiceOptionItem property can only contain items of type \App\Lib\Unifaun\StructType\ServiceOptionItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceOptionItem[] = $item;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
