<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DangerousGoods StructType
 * @subpackage Structs
 */
class DangerousGoods extends AbstractStructBase
{
    /**
     * The unNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:unNo
     * @var string
     */
    public $unNo;
    /**
     * The adrClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:adrClass
     * @var string
     */
    public $adrClass;
    /**
     * The packGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:packGroup
     * @var string
     */
    public $packGroup;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:weight
     * @var float
     */
    public $weight;
    /**
     * The netWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:netWeight
     * @var float
     */
    public $netWeight;
    /**
     * The netWeightExplSub
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:netWeightExplSub
     * @var string
     */
    public $netWeightExplSub;
    /**
     * The noOfPackages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:noOfPackages
     * @var int
     */
    public $noOfPackages;
    /**
     * The packageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:packageType
     * @var string
     */
    public $packageType;
    /**
     * The mp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:mp
     * @var string
     */
    public $mp;
    /**
     * The flamePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:flamePoint
     * @var string
     */
    public $flamePoint;
    /**
     * The lq
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:lq
     * @var string
     */
    public $lq;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Category
     */
    public $Category;
    /**
     * The ems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:ems
     * @var string
     */
    public $ems;
    /**
     * The sp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:sp
     * @var string
     */
    public $sp;
    /**
     * The tunnelRestrictionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:tunnelRestrictionCode
     * @var string
     */
    public $tunnelRestrictionCode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:description
     * @var string[]
     */
    public $description;
    /**
     * Constructor method for DangerousGoods
     * @uses DangerousGoods::setUnNo()
     * @uses DangerousGoods::setAdrClass()
     * @uses DangerousGoods::setPackGroup()
     * @uses DangerousGoods::setWeight()
     * @uses DangerousGoods::setNetWeight()
     * @uses DangerousGoods::setNetWeightExplSub()
     * @uses DangerousGoods::setNoOfPackages()
     * @uses DangerousGoods::setPackageType()
     * @uses DangerousGoods::setMp()
     * @uses DangerousGoods::setFlamePoint()
     * @uses DangerousGoods::setLq()
     * @uses DangerousGoods::setCategory()
     * @uses DangerousGoods::setEms()
     * @uses DangerousGoods::setSp()
     * @uses DangerousGoods::setTunnelRestrictionCode()
     * @uses DangerousGoods::setDescription()
     * @param string $unNo
     * @param string $adrClass
     * @param string $packGroup
     * @param float $weight
     * @param float $netWeight
     * @param string $netWeightExplSub
     * @param int $noOfPackages
     * @param string $packageType
     * @param string $mp
     * @param string $flamePoint
     * @param string $lq
     * @param \App\Lib\Unifaun\StructType\Category $category
     * @param string $ems
     * @param string $sp
     * @param string $tunnelRestrictionCode
     * @param string[] $description
     */
    public function __construct($unNo = null, $adrClass = null, $packGroup = null, $weight = null, $netWeight = null, $netWeightExplSub = null, $noOfPackages = null, $packageType = null, $mp = null, $flamePoint = null, $lq = null, \App\Lib\Unifaun\StructType\Category $category = null, $ems = null, $sp = null, $tunnelRestrictionCode = null, array $description = array())
    {
        $this
            ->setUnNo($unNo)
            ->setAdrClass($adrClass)
            ->setPackGroup($packGroup)
            ->setWeight($weight)
            ->setNetWeight($netWeight)
            ->setNetWeightExplSub($netWeightExplSub)
            ->setNoOfPackages($noOfPackages)
            ->setPackageType($packageType)
            ->setMp($mp)
            ->setFlamePoint($flamePoint)
            ->setLq($lq)
            ->setCategory($category)
            ->setEms($ems)
            ->setSp($sp)
            ->setTunnelRestrictionCode($tunnelRestrictionCode)
            ->setDescription($description);
    }
    /**
     * Get unNo value
     * @return string|null
     */
    public function getUnNo()
    {
        return $this->unNo;
    }
    /**
     * Set unNo value
     * @param string $unNo
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setUnNo($unNo = null)
    {
        // validation for constraint: string
        if (!is_null($unNo) && !is_string($unNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unNo)), __LINE__);
        }
        $this->unNo = $unNo;
        return $this;
    }
    /**
     * Get adrClass value
     * @return string|null
     */
    public function getAdrClass()
    {
        return $this->adrClass;
    }
    /**
     * Set adrClass value
     * @param string $adrClass
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setAdrClass($adrClass = null)
    {
        // validation for constraint: string
        if (!is_null($adrClass) && !is_string($adrClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adrClass)), __LINE__);
        }
        $this->adrClass = $adrClass;
        return $this;
    }
    /**
     * Get packGroup value
     * @return string|null
     */
    public function getPackGroup()
    {
        return $this->packGroup;
    }
    /**
     * Set packGroup value
     * @param string $packGroup
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setPackGroup($packGroup = null)
    {
        // validation for constraint: string
        if (!is_null($packGroup) && !is_string($packGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packGroup)), __LINE__);
        }
        $this->packGroup = $packGroup;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setWeight($weight = null)
    {
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get netWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param float $netWeight
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setNetWeight($netWeight = null)
    {
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get netWeightExplSub value
     * @return string|null
     */
    public function getNetWeightExplSub()
    {
        return $this->netWeightExplSub;
    }
    /**
     * Set netWeightExplSub value
     * @param string $netWeightExplSub
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setNetWeightExplSub($netWeightExplSub = null)
    {
        // validation for constraint: string
        if (!is_null($netWeightExplSub) && !is_string($netWeightExplSub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($netWeightExplSub)), __LINE__);
        }
        $this->netWeightExplSub = $netWeightExplSub;
        return $this;
    }
    /**
     * Get noOfPackages value
     * @return int|null
     */
    public function getNoOfPackages()
    {
        return $this->noOfPackages;
    }
    /**
     * Set noOfPackages value
     * @param int $noOfPackages
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setNoOfPackages($noOfPackages = null)
    {
        // validation for constraint: int
        if (!is_null($noOfPackages) && !is_numeric($noOfPackages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noOfPackages)), __LINE__);
        }
        $this->noOfPackages = $noOfPackages;
        return $this;
    }
    /**
     * Get packageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->packageType;
    }
    /**
     * Set packageType value
     * @param string $packageType
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageType)), __LINE__);
        }
        $this->packageType = $packageType;
        return $this;
    }
    /**
     * Get mp value
     * @return string|null
     */
    public function getMp()
    {
        return $this->mp;
    }
    /**
     * Set mp value
     * @param string $mp
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setMp($mp = null)
    {
        // validation for constraint: string
        if (!is_null($mp) && !is_string($mp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mp)), __LINE__);
        }
        $this->mp = $mp;
        return $this;
    }
    /**
     * Get flamePoint value
     * @return string|null
     */
    public function getFlamePoint()
    {
        return $this->flamePoint;
    }
    /**
     * Set flamePoint value
     * @param string $flamePoint
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setFlamePoint($flamePoint = null)
    {
        // validation for constraint: string
        if (!is_null($flamePoint) && !is_string($flamePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flamePoint)), __LINE__);
        }
        $this->flamePoint = $flamePoint;
        return $this;
    }
    /**
     * Get lq value
     * @return string|null
     */
    public function getLq()
    {
        return $this->lq;
    }
    /**
     * Set lq value
     * @param string $lq
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setLq($lq = null)
    {
        // validation for constraint: string
        if (!is_null($lq) && !is_string($lq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lq)), __LINE__);
        }
        $this->lq = $lq;
        return $this;
    }
    /**
     * Get Category value
     * @return \App\Lib\Unifaun\StructType\Category|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \App\Lib\Unifaun\StructType\Category $category
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setCategory(\App\Lib\Unifaun\StructType\Category $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get ems value
     * @return string|null
     */
    public function getEms()
    {
        return $this->ems;
    }
    /**
     * Set ems value
     * @param string $ems
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setEms($ems = null)
    {
        // validation for constraint: string
        if (!is_null($ems) && !is_string($ems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ems)), __LINE__);
        }
        $this->ems = $ems;
        return $this;
    }
    /**
     * Get sp value
     * @return string|null
     */
    public function getSp()
    {
        return $this->sp;
    }
    /**
     * Set sp value
     * @param string $sp
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setSp($sp = null)
    {
        // validation for constraint: string
        if (!is_null($sp) && !is_string($sp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sp)), __LINE__);
        }
        $this->sp = $sp;
        return $this;
    }
    /**
     * Get tunnelRestrictionCode value
     * @return string|null
     */
    public function getTunnelRestrictionCode()
    {
        return $this->tunnelRestrictionCode;
    }
    /**
     * Set tunnelRestrictionCode value
     * @param string $tunnelRestrictionCode
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setTunnelRestrictionCode($tunnelRestrictionCode = null)
    {
        // validation for constraint: string
        if (!is_null($tunnelRestrictionCode) && !is_string($tunnelRestrictionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tunnelRestrictionCode)), __LINE__);
        }
        $this->tunnelRestrictionCode = $tunnelRestrictionCode;
        return $this;
    }
    /**
     * Get description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $dangerousGoodsDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($dangerousGoodsDescriptionItem)) {
                throw new \InvalidArgumentException(sprintf('The description property can only contain items of string, "%s" given', is_object($dangerousGoodsDescriptionItem) ? get_class($dangerousGoodsDescriptionItem) : gettype($dangerousGoodsDescriptionItem)), __LINE__);
            }
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
