<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Archive ServiceType
 * @subpackage Services
 */
class Archive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named archive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\Archive $parameters
     * @return \App\Lib\Unifaun\StructType\ArchiveResponse|bool
     */
    public function archive(\App\Lib\Unifaun\StructType\Archive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->archive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\ArchiveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
