<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consignment StructType
 * @subpackage Structs
 */
class Consignment extends AbstractStructBase
{
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $orderNo;
    /**
     * The Part
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \App\Lib\Unifaun\StructType\Part[]
     */
    public $Part;
    /**
     * The GoodsItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \App\Lib\Unifaun\StructType\GoodsItem[]
     */
    public $GoodsItem;
    /**
     * The TransportProduct
     * @var \App\Lib\Unifaun\StructType\TransportProduct
     */
    public $TransportProduct;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Target
     */
    public $Target;
    /**
     * The Contents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Contents
     */
    public $Contents;
    /**
     * The GoodsGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\GoodsGroup[]
     */
    public $GoodsGroup;
    /**
     * The ConsignmentReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\ConsignmentReference[]
     */
    public $ConsignmentReference;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Note[]
     */
    public $Note;
    /**
     * The GoodsInvoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public $GoodsInvoice;
    /**
     * The orderType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $orderType;
    /**
     * The automaticBooking
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $automaticBooking;
    /**
     * The consignmentId
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $consignmentId;
    /**
     * The consignmentNo
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $consignmentNo;
    /**
     * The templateName
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $templateName;
    /**
     * The owner
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $owner;
    /**
     * Constructor method for Consignment
     * @uses Consignment::setOrderNo()
     * @uses Consignment::setPart()
     * @uses Consignment::setGoodsItem()
     * @uses Consignment::setTransportProduct()
     * @uses Consignment::setTarget()
     * @uses Consignment::setContents()
     * @uses Consignment::setGoodsGroup()
     * @uses Consignment::setConsignmentReference()
     * @uses Consignment::setNote()
     * @uses Consignment::setGoodsInvoice()
     * @uses Consignment::setOrderType()
     * @uses Consignment::setAutomaticBooking()
     * @uses Consignment::setConsignmentId()
     * @uses Consignment::setConsignmentNo()
     * @uses Consignment::setTemplateName()
     * @uses Consignment::setOwner()
     * @param string $orderNo
     * @param \App\Lib\Unifaun\StructType\Part[] $part
     * @param \App\Lib\Unifaun\StructType\GoodsItem[] $goodsItem
     * @param \App\Lib\Unifaun\StructType\TransportProduct $transportProduct
     * @param \App\Lib\Unifaun\StructType\Target $target
     * @param \App\Lib\Unifaun\StructType\Contents $contents
     * @param \App\Lib\Unifaun\StructType\GoodsGroup[] $goodsGroup
     * @param \App\Lib\Unifaun\StructType\ConsignmentReference[] $consignmentReference
     * @param \App\Lib\Unifaun\StructType\Note[] $note
     * @param \App\Lib\Unifaun\StructType\GoodsInvoice $goodsInvoice
     * @param string $orderType
     * @param string $automaticBooking
     * @param string $consignmentId
     * @param string $consignmentNo
     * @param string $templateName
     * @param string $owner
     */
    public function __construct($orderNo = null, array $part = array(), array $goodsItem = array(), \App\Lib\Unifaun\StructType\TransportProduct $transportProduct = null, \App\Lib\Unifaun\StructType\Target $target = null, \App\Lib\Unifaun\StructType\Contents $contents = null, array $goodsGroup = array(), array $consignmentReference = array(), array $note = array(), \App\Lib\Unifaun\StructType\GoodsInvoice $goodsInvoice = null, $orderType = null, $automaticBooking = null, $consignmentId = null, $consignmentNo = null, $templateName = null, $owner = null)
    {
        $this
            ->setOrderNo($orderNo)
            ->setPart($part)
            ->setGoodsItem($goodsItem)
            ->setTransportProduct($transportProduct)
            ->setTarget($target)
            ->setContents($contents)
            ->setGoodsGroup($goodsGroup)
            ->setConsignmentReference($consignmentReference)
            ->setNote($note)
            ->setGoodsInvoice($goodsInvoice)
            ->setOrderType($orderType)
            ->setAutomaticBooking($automaticBooking)
            ->setConsignmentId($consignmentId)
            ->setConsignmentNo($consignmentNo)
            ->setTemplateName($templateName)
            ->setOwner($owner);
    }
    /**
     * Get orderNo value
     * @return string
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get Part value
     * @return \App\Lib\Unifaun\StructType\Part[]|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * Set Part value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Part[] $part
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setPart(array $part = array())
    {
        foreach ($part as $consignmentPartItem) {
            // validation for constraint: itemType
            if (!$consignmentPartItem instanceof \App\Lib\Unifaun\StructType\Part) {
                throw new \InvalidArgumentException(sprintf('The Part property can only contain items of \App\Lib\Unifaun\StructType\Part, "%s" given', is_object($consignmentPartItem) ? get_class($consignmentPartItem) : gettype($consignmentPartItem)), __LINE__);
            }
        }
        $this->Part = $part;
        return $this;
    }
    /**
     * Add item to Part value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Part $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToPart(\App\Lib\Unifaun\StructType\Part $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Part) {
            throw new \InvalidArgumentException(sprintf('The Part property can only contain items of \App\Lib\Unifaun\StructType\Part, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Part[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \App\Lib\Unifaun\StructType\GoodsItem[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsItem[] $goodsItem
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        foreach ($goodsItem as $consignmentGoodsItemItem) {
            // validation for constraint: itemType
            if (!$consignmentGoodsItemItem instanceof \App\Lib\Unifaun\StructType\GoodsItem) {
                throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of \App\Lib\Unifaun\StructType\GoodsItem, "%s" given', is_object($consignmentGoodsItemItem) ? get_class($consignmentGoodsItemItem) : gettype($consignmentGoodsItemItem)), __LINE__);
            }
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsItem $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToGoodsItem(\App\Lib\Unifaun\StructType\GoodsItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\GoodsItem) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of \App\Lib\Unifaun\StructType\GoodsItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get TransportProduct value
     * @return \App\Lib\Unifaun\StructType\TransportProduct|null
     */
    public function getTransportProduct()
    {
        return $this->TransportProduct;
    }
    /**
     * Set TransportProduct value
     * @param \App\Lib\Unifaun\StructType\TransportProduct $transportProduct
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setTransportProduct(\App\Lib\Unifaun\StructType\TransportProduct $transportProduct = null)
    {
        $this->TransportProduct = $transportProduct;
        return $this;
    }
    /**
     * Get Target value
     * @return \App\Lib\Unifaun\StructType\Target|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param \App\Lib\Unifaun\StructType\Target $target
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setTarget(\App\Lib\Unifaun\StructType\Target $target = null)
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Contents value
     * @return \App\Lib\Unifaun\StructType\Contents|null
     */
    public function getContents()
    {
        return $this->Contents;
    }
    /**
     * Set Contents value
     * @param \App\Lib\Unifaun\StructType\Contents $contents
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setContents(\App\Lib\Unifaun\StructType\Contents $contents = null)
    {
        $this->Contents = $contents;
        return $this;
    }
    /**
     * Get GoodsGroup value
     * @return \App\Lib\Unifaun\StructType\GoodsGroup[]|null
     */
    public function getGoodsGroup()
    {
        return $this->GoodsGroup;
    }
    /**
     * Set GoodsGroup value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsGroup[] $goodsGroup
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setGoodsGroup(array $goodsGroup = array())
    {
        foreach ($goodsGroup as $consignmentGoodsGroupItem) {
            // validation for constraint: itemType
            if (!$consignmentGoodsGroupItem instanceof \App\Lib\Unifaun\StructType\GoodsGroup) {
                throw new \InvalidArgumentException(sprintf('The GoodsGroup property can only contain items of \App\Lib\Unifaun\StructType\GoodsGroup, "%s" given', is_object($consignmentGoodsGroupItem) ? get_class($consignmentGoodsGroupItem) : gettype($consignmentGoodsGroupItem)), __LINE__);
            }
        }
        $this->GoodsGroup = $goodsGroup;
        return $this;
    }
    /**
     * Add item to GoodsGroup value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsGroup $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToGoodsGroup(\App\Lib\Unifaun\StructType\GoodsGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\GoodsGroup) {
            throw new \InvalidArgumentException(sprintf('The GoodsGroup property can only contain items of \App\Lib\Unifaun\StructType\GoodsGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GoodsGroup[] = $item;
        return $this;
    }
    /**
     * Get ConsignmentReference value
     * @return \App\Lib\Unifaun\StructType\ConsignmentReference[]|null
     */
    public function getConsignmentReference()
    {
        return $this->ConsignmentReference;
    }
    /**
     * Set ConsignmentReference value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ConsignmentReference[] $consignmentReference
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setConsignmentReference(array $consignmentReference = array())
    {
        foreach ($consignmentReference as $consignmentConsignmentReferenceItem) {
            // validation for constraint: itemType
            if (!$consignmentConsignmentReferenceItem instanceof \App\Lib\Unifaun\StructType\ConsignmentReference) {
                throw new \InvalidArgumentException(sprintf('The ConsignmentReference property can only contain items of \App\Lib\Unifaun\StructType\ConsignmentReference, "%s" given', is_object($consignmentConsignmentReferenceItem) ? get_class($consignmentConsignmentReferenceItem) : gettype($consignmentConsignmentReferenceItem)), __LINE__);
            }
        }
        $this->ConsignmentReference = $consignmentReference;
        return $this;
    }
    /**
     * Add item to ConsignmentReference value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ConsignmentReference $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToConsignmentReference(\App\Lib\Unifaun\StructType\ConsignmentReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ConsignmentReference) {
            throw new \InvalidArgumentException(sprintf('The ConsignmentReference property can only contain items of \App\Lib\Unifaun\StructType\ConsignmentReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConsignmentReference[] = $item;
        return $this;
    }
    /**
     * Get Note value
     * @return \App\Lib\Unifaun\StructType\Note[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Note[] $note
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setNote(array $note = array())
    {
        foreach ($note as $consignmentNoteItem) {
            // validation for constraint: itemType
            if (!$consignmentNoteItem instanceof \App\Lib\Unifaun\StructType\Note) {
                throw new \InvalidArgumentException(sprintf('The Note property can only contain items of \App\Lib\Unifaun\StructType\Note, "%s" given', is_object($consignmentNoteItem) ? get_class($consignmentNoteItem) : gettype($consignmentNoteItem)), __LINE__);
            }
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Note $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToNote(\App\Lib\Unifaun\StructType\Note $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Note) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of \App\Lib\Unifaun\StructType\Note, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get GoodsInvoice value
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice|null
     */
    public function getGoodsInvoice()
    {
        return $this->GoodsInvoice;
    }
    /**
     * Set GoodsInvoice value
     * @param \App\Lib\Unifaun\StructType\GoodsInvoice $goodsInvoice
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setGoodsInvoice(\App\Lib\Unifaun\StructType\GoodsInvoice $goodsInvoice = null)
    {
        $this->GoodsInvoice = $goodsInvoice;
        return $this;
    }
    /**
     * Get orderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @param string $orderType
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderType)), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Get automaticBooking value
     * @return string|null
     */
    public function getAutomaticBooking()
    {
        return $this->automaticBooking;
    }
    /**
     * Set automaticBooking value
     * @param string $automaticBooking
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setAutomaticBooking($automaticBooking = null)
    {
        // validation for constraint: string
        if (!is_null($automaticBooking) && !is_string($automaticBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automaticBooking)), __LINE__);
        }
        $this->automaticBooking = $automaticBooking;
        return $this;
    }
    /**
     * Get consignmentId value
     * @return string|null
     */
    public function getConsignmentId()
    {
        return $this->consignmentId;
    }
    /**
     * Set consignmentId value
     * @param string $consignmentId
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setConsignmentId($consignmentId = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentId) && !is_string($consignmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentId)), __LINE__);
        }
        $this->consignmentId = $consignmentId;
        return $this;
    }
    /**
     * Get consignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->consignmentNo;
    }
    /**
     * Set consignmentNo value
     * @param string $consignmentNo
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentNo)), __LINE__);
        }
        $this->consignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get templateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->templateName;
    }
    /**
     * Set templateName value
     * @param string $templateName
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateName)), __LINE__);
        }
        $this->templateName = $templateName;
        return $this;
    }
    /**
     * Get owner value
     * @return string|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param string $owner
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($owner)), __LINE__);
        }
        $this->owner = $owner;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
