<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Communication StructType
 * @subpackage Structs
 */
class Communication extends AbstractStructBase
{
    /**
     * The contactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:contactPerson
     * @var string
     */
    public $contactPerson;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:phone
     * @var string
     */
    public $phone;
    /**
     * The mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Mobile
     */
    public $mobile;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:fax
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Email
     */
    public $email;
    /**
     * Constructor method for Communication
     * @uses Communication::setContactPerson()
     * @uses Communication::setPhone()
     * @uses Communication::setMobile()
     * @uses Communication::setFax()
     * @uses Communication::setEmail()
     * @param string $contactPerson
     * @param string $phone
     * @param \App\Lib\Unifaun\StructType\Mobile $mobile
     * @param string $fax
     * @param \App\Lib\Unifaun\StructType\Email $email
     */
    public function __construct($contactPerson = null, $phone = null, \App\Lib\Unifaun\StructType\Mobile $mobile = null, $fax = null, \App\Lib\Unifaun\StructType\Email $email = null)
    {
        $this
            ->setContactPerson($contactPerson)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setEmail($email);
    }
    /**
     * Get contactPerson value
     * @return string|null
     */
    public function getContactPerson()
    {
        return $this->contactPerson;
    }
    /**
     * Set contactPerson value
     * @param string $contactPerson
     * @return \App\Lib\Unifaun\StructType\Communication
     */
    public function setContactPerson($contactPerson = null)
    {
        // validation for constraint: string
        if (!is_null($contactPerson) && !is_string($contactPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPerson, true), gettype($contactPerson)), __LINE__);
        }
        $this->contactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \App\Lib\Unifaun\StructType\Communication
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get mobile value
     * @return \App\Lib\Unifaun\StructType\Mobile|null
     */
    public function getMobile()
    {
        return $this->mobile;
    }
    /**
     * Set mobile value
     * @param \App\Lib\Unifaun\StructType\Mobile $mobile
     * @return \App\Lib\Unifaun\StructType\Communication
     */
    public function setMobile(\App\Lib\Unifaun\StructType\Mobile $mobile = null)
    {
        $this->mobile = $mobile;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \App\Lib\Unifaun\StructType\Communication
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return \App\Lib\Unifaun\StructType\Email|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param \App\Lib\Unifaun\StructType\Email $email
     * @return \App\Lib\Unifaun\StructType\Communication
     */
    public function setEmail(\App\Lib\Unifaun\StructType\Email $email = null)
    {
        $this->email = $email;
        return $this;
    }
}
