<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DangerousGoods StructType
 * @subpackage Structs
 */
class DangerousGoods extends AbstractStructBase
{
    /**
     * The unNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:unNo
     * @var string
     */
    public $unNo;
    /**
     * The adrClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:adrClass
     * @var string
     */
    public $adrClass;
    /**
     * The packGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:packGroup
     * @var string
     */
    public $packGroup;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:weight
     * @var float
     */
    public $weight;
    /**
     * The netWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:netWeight
     * @var float
     */
    public $netWeight;
    /**
     * The netWeightExplSub
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:netWeightExplSub
     * @var string
     */
    public $netWeightExplSub;
    /**
     * The noOfPackages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:noOfPackages
     * @var int
     */
    public $noOfPackages;
    /**
     * The packageType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:packageType
     * @var string
     */
    public $packageType;
    /**
     * The mp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:mp
     * @var string
     */
    public $mp;
    /**
     * The flamePoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:flamePoint
     * @var string
     */
    public $flamePoint;
    /**
     * The lq
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:lq
     * @var string
     */
    public $lq;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Category
     */
    public $Category;
    /**
     * The ems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:ems
     * @var string
     */
    public $ems;
    /**
     * The sp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:sp
     * @var string
     */
    public $sp;
    /**
     * The tunnelRestrictionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:tunnelRestrictionCode
     * @var string
     */
    public $tunnelRestrictionCode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:description
     * @var string[]
     */
    public $description;
    /**
     * Constructor method for DangerousGoods
     * @uses DangerousGoods::setUnNo()
     * @uses DangerousGoods::setAdrClass()
     * @uses DangerousGoods::setPackGroup()
     * @uses DangerousGoods::setWeight()
     * @uses DangerousGoods::setNetWeight()
     * @uses DangerousGoods::setNetWeightExplSub()
     * @uses DangerousGoods::setNoOfPackages()
     * @uses DangerousGoods::setPackageType()
     * @uses DangerousGoods::setMp()
     * @uses DangerousGoods::setFlamePoint()
     * @uses DangerousGoods::setLq()
     * @uses DangerousGoods::setCategory()
     * @uses DangerousGoods::setEms()
     * @uses DangerousGoods::setSp()
     * @uses DangerousGoods::setTunnelRestrictionCode()
     * @uses DangerousGoods::setDescription()
     * @param string $unNo
     * @param string $adrClass
     * @param string $packGroup
     * @param float $weight
     * @param float $netWeight
     * @param string $netWeightExplSub
     * @param int $noOfPackages
     * @param string $packageType
     * @param string $mp
     * @param string $flamePoint
     * @param string $lq
     * @param \App\Lib\Unifaun\StructType\Category $category
     * @param string $ems
     * @param string $sp
     * @param string $tunnelRestrictionCode
     * @param string[] $description
     */
    public function __construct($unNo = null, $adrClass = null, $packGroup = null, $weight = null, $netWeight = null, $netWeightExplSub = null, $noOfPackages = null, $packageType = null, $mp = null, $flamePoint = null, $lq = null, \App\Lib\Unifaun\StructType\Category $category = null, $ems = null, $sp = null, $tunnelRestrictionCode = null, array $description = array())
    {
        $this
            ->setUnNo($unNo)
            ->setAdrClass($adrClass)
            ->setPackGroup($packGroup)
            ->setWeight($weight)
            ->setNetWeight($netWeight)
            ->setNetWeightExplSub($netWeightExplSub)
            ->setNoOfPackages($noOfPackages)
            ->setPackageType($packageType)
            ->setMp($mp)
            ->setFlamePoint($flamePoint)
            ->setLq($lq)
            ->setCategory($category)
            ->setEms($ems)
            ->setSp($sp)
            ->setTunnelRestrictionCode($tunnelRestrictionCode)
            ->setDescription($description);
    }
    /**
     * Get unNo value
     * @return string|null
     */
    public function getUnNo()
    {
        return $this->unNo;
    }
    /**
     * Set unNo value
     * @param string $unNo
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setUnNo($unNo = null)
    {
        // validation for constraint: string
        if (!is_null($unNo) && !is_string($unNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unNo, true), gettype($unNo)), __LINE__);
        }
        $this->unNo = $unNo;
        return $this;
    }
    /**
     * Get adrClass value
     * @return string|null
     */
    public function getAdrClass()
    {
        return $this->adrClass;
    }
    /**
     * Set adrClass value
     * @param string $adrClass
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setAdrClass($adrClass = null)
    {
        // validation for constraint: string
        if (!is_null($adrClass) && !is_string($adrClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adrClass, true), gettype($adrClass)), __LINE__);
        }
        $this->adrClass = $adrClass;
        return $this;
    }
    /**
     * Get packGroup value
     * @return string|null
     */
    public function getPackGroup()
    {
        return $this->packGroup;
    }
    /**
     * Set packGroup value
     * @param string $packGroup
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setPackGroup($packGroup = null)
    {
        // validation for constraint: string
        if (!is_null($packGroup) && !is_string($packGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packGroup, true), gettype($packGroup)), __LINE__);
        }
        $this->packGroup = $packGroup;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get netWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param float $netWeight
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setNetWeight($netWeight = null)
    {
        // validation for constraint: float
        if (!is_null($netWeight) && !(is_float($netWeight) || is_numeric($netWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeight, true), gettype($netWeight)), __LINE__);
        }
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get netWeightExplSub value
     * @return string|null
     */
    public function getNetWeightExplSub()
    {
        return $this->netWeightExplSub;
    }
    /**
     * Set netWeightExplSub value
     * @param string $netWeightExplSub
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setNetWeightExplSub($netWeightExplSub = null)
    {
        // validation for constraint: string
        if (!is_null($netWeightExplSub) && !is_string($netWeightExplSub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netWeightExplSub, true), gettype($netWeightExplSub)), __LINE__);
        }
        $this->netWeightExplSub = $netWeightExplSub;
        return $this;
    }
    /**
     * Get noOfPackages value
     * @return int|null
     */
    public function getNoOfPackages()
    {
        return $this->noOfPackages;
    }
    /**
     * Set noOfPackages value
     * @param int $noOfPackages
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setNoOfPackages($noOfPackages = null)
    {
        // validation for constraint: int
        if (!is_null($noOfPackages) && !(is_int($noOfPackages) || ctype_digit($noOfPackages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($noOfPackages, true), gettype($noOfPackages)), __LINE__);
        }
        $this->noOfPackages = $noOfPackages;
        return $this;
    }
    /**
     * Get packageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->packageType;
    }
    /**
     * Set packageType value
     * @param string $packageType
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageType, true), gettype($packageType)), __LINE__);
        }
        $this->packageType = $packageType;
        return $this;
    }
    /**
     * Get mp value
     * @return string|null
     */
    public function getMp()
    {
        return $this->mp;
    }
    /**
     * Set mp value
     * @param string $mp
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setMp($mp = null)
    {
        // validation for constraint: string
        if (!is_null($mp) && !is_string($mp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mp, true), gettype($mp)), __LINE__);
        }
        $this->mp = $mp;
        return $this;
    }
    /**
     * Get flamePoint value
     * @return string|null
     */
    public function getFlamePoint()
    {
        return $this->flamePoint;
    }
    /**
     * Set flamePoint value
     * @param string $flamePoint
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setFlamePoint($flamePoint = null)
    {
        // validation for constraint: string
        if (!is_null($flamePoint) && !is_string($flamePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flamePoint, true), gettype($flamePoint)), __LINE__);
        }
        $this->flamePoint = $flamePoint;
        return $this;
    }
    /**
     * Get lq value
     * @return string|null
     */
    public function getLq()
    {
        return $this->lq;
    }
    /**
     * Set lq value
     * @param string $lq
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setLq($lq = null)
    {
        // validation for constraint: string
        if (!is_null($lq) && !is_string($lq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lq, true), gettype($lq)), __LINE__);
        }
        $this->lq = $lq;
        return $this;
    }
    /**
     * Get Category value
     * @return \App\Lib\Unifaun\StructType\Category|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \App\Lib\Unifaun\StructType\Category $category
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setCategory(\App\Lib\Unifaun\StructType\Category $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get ems value
     * @return string|null
     */
    public function getEms()
    {
        return $this->ems;
    }
    /**
     * Set ems value
     * @param string $ems
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setEms($ems = null)
    {
        // validation for constraint: string
        if (!is_null($ems) && !is_string($ems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ems, true), gettype($ems)), __LINE__);
        }
        $this->ems = $ems;
        return $this;
    }
    /**
     * Get sp value
     * @return string|null
     */
    public function getSp()
    {
        return $this->sp;
    }
    /**
     * Set sp value
     * @param string $sp
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setSp($sp = null)
    {
        // validation for constraint: string
        if (!is_null($sp) && !is_string($sp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sp, true), gettype($sp)), __LINE__);
        }
        $this->sp = $sp;
        return $this;
    }
    /**
     * Get tunnelRestrictionCode value
     * @return string|null
     */
    public function getTunnelRestrictionCode()
    {
        return $this->tunnelRestrictionCode;
    }
    /**
     * Set tunnelRestrictionCode value
     * @param string $tunnelRestrictionCode
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setTunnelRestrictionCode($tunnelRestrictionCode = null)
    {
        // validation for constraint: string
        if (!is_null($tunnelRestrictionCode) && !is_string($tunnelRestrictionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tunnelRestrictionCode, true), gettype($tunnelRestrictionCode)), __LINE__);
        }
        $this->tunnelRestrictionCode = $tunnelRestrictionCode;
        return $this;
    }
    /**
     * Get description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dangerousGoodsDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($dangerousGoodsDescriptionItem)) {
                $invalidValues[] = is_object($dangerousGoodsDescriptionItem) ? get_class($dangerousGoodsDescriptionItem) : sprintf('%s(%s)', gettype($dangerousGoodsDescriptionItem), var_export($dangerousGoodsDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
}
