<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCalculatedPrice StructType
 * Meta information extracted from the WSDL
 * - type: tns:getCalculatedPrice
 * @subpackage Structs
 */
class GetCalculatedPrice extends AbstractStructBase
{
    /**
     * The AuthenticationToken
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\AuthenticationToken
     */
    public $AuthenticationToken;
    /**
     * The arrayOfConsignmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $arrayOfConsignmentNo;
    /**
     * Constructor method for getCalculatedPrice
     * @uses GetCalculatedPrice::setAuthenticationToken()
     * @uses GetCalculatedPrice::setArrayOfConsignmentNo()
     * @param \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken
     * @param string[] $arrayOfConsignmentNo
     */
    public function __construct(\App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken = null, array $arrayOfConsignmentNo = array())
    {
        $this
            ->setAuthenticationToken($authenticationToken)
            ->setArrayOfConsignmentNo($arrayOfConsignmentNo);
    }
    /**
     * Get AuthenticationToken value
     * @return \App\Lib\Unifaun\StructType\AuthenticationToken|null
     */
    public function getAuthenticationToken()
    {
        return $this->AuthenticationToken;
    }
    /**
     * Set AuthenticationToken value
     * @param \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken
     * @return \App\Lib\Unifaun\StructType\GetCalculatedPrice
     */
    public function setAuthenticationToken(\App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken = null)
    {
        $this->AuthenticationToken = $authenticationToken;
        return $this;
    }
    /**
     * Get arrayOfConsignmentNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getArrayOfConsignmentNo()
    {
        return isset($this->arrayOfConsignmentNo) ? $this->arrayOfConsignmentNo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArrayOfConsignmentNo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArrayOfConsignmentNo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArrayOfConsignmentNoForArrayConstraintsFromSetArrayOfConsignmentNo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCalculatedPriceArrayOfConsignmentNoItem) {
            // validation for constraint: itemType
            if (!is_string($getCalculatedPriceArrayOfConsignmentNoItem)) {
                $invalidValues[] = is_object($getCalculatedPriceArrayOfConsignmentNoItem) ? get_class($getCalculatedPriceArrayOfConsignmentNoItem) : sprintf('%s(%s)', gettype($getCalculatedPriceArrayOfConsignmentNoItem), var_export($getCalculatedPriceArrayOfConsignmentNoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The arrayOfConsignmentNo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set arrayOfConsignmentNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $arrayOfConsignmentNo
     * @return \App\Lib\Unifaun\StructType\GetCalculatedPrice
     */
    public function setArrayOfConsignmentNo(array $arrayOfConsignmentNo = array())
    {
        // validation for constraint: array
        if ('' !== ($arrayOfConsignmentNoArrayErrorMessage = self::validateArrayOfConsignmentNoForArrayConstraintsFromSetArrayOfConsignmentNo($arrayOfConsignmentNo))) {
            throw new \InvalidArgumentException($arrayOfConsignmentNoArrayErrorMessage, __LINE__);
        }
        if (is_null($arrayOfConsignmentNo) || (is_array($arrayOfConsignmentNo) && empty($arrayOfConsignmentNo))) {
            unset($this->arrayOfConsignmentNo);
        } else {
            $this->arrayOfConsignmentNo = $arrayOfConsignmentNo;
        }
        return $this;
    }
    /**
     * Add item to arrayOfConsignmentNo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\GetCalculatedPrice
     */
    public function addToArrayOfConsignmentNo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The arrayOfConsignmentNo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->arrayOfConsignmentNo[] = $item;
        return $this;
    }
}
