<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consignment StructType
 * @subpackage Structs
 */
class Consignment extends AbstractStructBase
{
    /**
     * The orderNo
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $orderNo;
    /**
     * The Part
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \App\Lib\Unifaun\StructType\Part[]
     */
    public $Part;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \App\Lib\Unifaun\StructType\GoodsItem[]
     */
    public $GoodsItem;
    /**
     * The TransportProduct
     * @var \App\Lib\Unifaun\StructType\TransportProduct
     */
    public $TransportProduct;
    /**
     * The Target
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Target
     */
    public $Target;
    /**
     * The Contents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Contents
     */
    public $Contents;
    /**
     * The GoodsGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\GoodsGroup[]
     */
    public $GoodsGroup;
    /**
     * The ConsignmentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\ConsignmentReference[]
     */
    public $ConsignmentReference;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Note[]
     */
    public $Note;
    /**
     * The GoodsInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\GoodsInvoice
     */
    public $GoodsInvoice;
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $orderType;
    /**
     * The automaticBooking
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $automaticBooking;
    /**
     * The consignmentId
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $consignmentId;
    /**
     * The consignmentNo
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $consignmentNo;
    /**
     * The templateName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $templateName;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $owner;
    /**
     * Constructor method for Consignment
     * @uses Consignment::setOrderNo()
     * @uses Consignment::setPart()
     * @uses Consignment::setGoodsItem()
     * @uses Consignment::setTransportProduct()
     * @uses Consignment::setTarget()
     * @uses Consignment::setContents()
     * @uses Consignment::setGoodsGroup()
     * @uses Consignment::setConsignmentReference()
     * @uses Consignment::setNote()
     * @uses Consignment::setGoodsInvoice()
     * @uses Consignment::setOrderType()
     * @uses Consignment::setAutomaticBooking()
     * @uses Consignment::setConsignmentId()
     * @uses Consignment::setConsignmentNo()
     * @uses Consignment::setTemplateName()
     * @uses Consignment::setOwner()
     * @param string $orderNo
     * @param \App\Lib\Unifaun\StructType\Part[] $part
     * @param \App\Lib\Unifaun\StructType\GoodsItem[] $goodsItem
     * @param \App\Lib\Unifaun\StructType\TransportProduct $transportProduct
     * @param \App\Lib\Unifaun\StructType\Target $target
     * @param \App\Lib\Unifaun\StructType\Contents $contents
     * @param \App\Lib\Unifaun\StructType\GoodsGroup[] $goodsGroup
     * @param \App\Lib\Unifaun\StructType\ConsignmentReference[] $consignmentReference
     * @param \App\Lib\Unifaun\StructType\Note[] $note
     * @param \App\Lib\Unifaun\StructType\GoodsInvoice $goodsInvoice
     * @param string $orderType
     * @param string $automaticBooking
     * @param string $consignmentId
     * @param string $consignmentNo
     * @param string $templateName
     * @param string $owner
     */
    public function __construct($orderNo = null, array $part = array(), array $goodsItem = array(), \App\Lib\Unifaun\StructType\TransportProduct $transportProduct = null, \App\Lib\Unifaun\StructType\Target $target = null, \App\Lib\Unifaun\StructType\Contents $contents = null, array $goodsGroup = array(), array $consignmentReference = array(), array $note = array(), \App\Lib\Unifaun\StructType\GoodsInvoice $goodsInvoice = null, $orderType = null, $automaticBooking = null, $consignmentId = null, $consignmentNo = null, $templateName = null, $owner = null)
    {
        $this
            ->setOrderNo($orderNo)
            ->setPart($part)
            ->setGoodsItem($goodsItem)
            ->setTransportProduct($transportProduct)
            ->setTarget($target)
            ->setContents($contents)
            ->setGoodsGroup($goodsGroup)
            ->setConsignmentReference($consignmentReference)
            ->setNote($note)
            ->setGoodsInvoice($goodsInvoice)
            ->setOrderType($orderType)
            ->setAutomaticBooking($automaticBooking)
            ->setConsignmentId($consignmentId)
            ->setConsignmentNo($consignmentNo)
            ->setTemplateName($templateName)
            ->setOwner($owner);
    }
    /**
     * Get orderNo value
     * @return string
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNo, true), gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get Part value
     * @return \App\Lib\Unifaun\StructType\Part[]|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * This method is responsible for validating the values passed to the setPart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPart method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartForArrayConstraintsFromSetPart(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentPartItem) {
            // validation for constraint: itemType
            if (!$consignmentPartItem instanceof \App\Lib\Unifaun\StructType\Part) {
                $invalidValues[] = is_object($consignmentPartItem) ? get_class($consignmentPartItem) : sprintf('%s(%s)', gettype($consignmentPartItem), var_export($consignmentPartItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Part property can only contain items of type \App\Lib\Unifaun\StructType\Part, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Part value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Part[] $part
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setPart(array $part = array())
    {
        // validation for constraint: array
        if ('' !== ($partArrayErrorMessage = self::validatePartForArrayConstraintsFromSetPart($part))) {
            throw new \InvalidArgumentException($partArrayErrorMessage, __LINE__);
        }
        $this->Part = $part;
        return $this;
    }
    /**
     * Add item to Part value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Part $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToPart(\App\Lib\Unifaun\StructType\Part $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Part) {
            throw new \InvalidArgumentException(sprintf('The Part property can only contain items of type \App\Lib\Unifaun\StructType\Part, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Part[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \App\Lib\Unifaun\StructType\GoodsItem[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentGoodsItemItem) {
            // validation for constraint: itemType
            if (!$consignmentGoodsItemItem instanceof \App\Lib\Unifaun\StructType\GoodsItem) {
                $invalidValues[] = is_object($consignmentGoodsItemItem) ? get_class($consignmentGoodsItemItem) : sprintf('%s(%s)', gettype($consignmentGoodsItemItem), var_export($consignmentGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \App\Lib\Unifaun\StructType\GoodsItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsItem[] $goodsItem
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsItem $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToGoodsItem(\App\Lib\Unifaun\StructType\GoodsItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\GoodsItem) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \App\Lib\Unifaun\StructType\GoodsItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get TransportProduct value
     * @return \App\Lib\Unifaun\StructType\TransportProduct|null
     */
    public function getTransportProduct()
    {
        return $this->TransportProduct;
    }
    /**
     * Set TransportProduct value
     * @param \App\Lib\Unifaun\StructType\TransportProduct $transportProduct
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setTransportProduct(\App\Lib\Unifaun\StructType\TransportProduct $transportProduct = null)
    {
        $this->TransportProduct = $transportProduct;
        return $this;
    }
    /**
     * Get Target value
     * @return \App\Lib\Unifaun\StructType\Target|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param \App\Lib\Unifaun\StructType\Target $target
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setTarget(\App\Lib\Unifaun\StructType\Target $target = null)
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Contents value
     * @return \App\Lib\Unifaun\StructType\Contents|null
     */
    public function getContents()
    {
        return $this->Contents;
    }
    /**
     * Set Contents value
     * @param \App\Lib\Unifaun\StructType\Contents $contents
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setContents(\App\Lib\Unifaun\StructType\Contents $contents = null)
    {
        $this->Contents = $contents;
        return $this;
    }
    /**
     * Get GoodsGroup value
     * @return \App\Lib\Unifaun\StructType\GoodsGroup[]|null
     */
    public function getGoodsGroup()
    {
        return $this->GoodsGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsGroupForArrayConstraintsFromSetGoodsGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentGoodsGroupItem) {
            // validation for constraint: itemType
            if (!$consignmentGoodsGroupItem instanceof \App\Lib\Unifaun\StructType\GoodsGroup) {
                $invalidValues[] = is_object($consignmentGoodsGroupItem) ? get_class($consignmentGoodsGroupItem) : sprintf('%s(%s)', gettype($consignmentGoodsGroupItem), var_export($consignmentGoodsGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsGroup property can only contain items of type \App\Lib\Unifaun\StructType\GoodsGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsGroup value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsGroup[] $goodsGroup
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setGoodsGroup(array $goodsGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsGroupArrayErrorMessage = self::validateGoodsGroupForArrayConstraintsFromSetGoodsGroup($goodsGroup))) {
            throw new \InvalidArgumentException($goodsGroupArrayErrorMessage, __LINE__);
        }
        $this->GoodsGroup = $goodsGroup;
        return $this;
    }
    /**
     * Add item to GoodsGroup value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsGroup $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToGoodsGroup(\App\Lib\Unifaun\StructType\GoodsGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\GoodsGroup) {
            throw new \InvalidArgumentException(sprintf('The GoodsGroup property can only contain items of type \App\Lib\Unifaun\StructType\GoodsGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsGroup[] = $item;
        return $this;
    }
    /**
     * Get ConsignmentReference value
     * @return \App\Lib\Unifaun\StructType\ConsignmentReference[]|null
     */
    public function getConsignmentReference()
    {
        return $this->ConsignmentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignmentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignmentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentReferenceForArrayConstraintsFromSetConsignmentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentConsignmentReferenceItem) {
            // validation for constraint: itemType
            if (!$consignmentConsignmentReferenceItem instanceof \App\Lib\Unifaun\StructType\ConsignmentReference) {
                $invalidValues[] = is_object($consignmentConsignmentReferenceItem) ? get_class($consignmentConsignmentReferenceItem) : sprintf('%s(%s)', gettype($consignmentConsignmentReferenceItem), var_export($consignmentConsignmentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConsignmentReference property can only contain items of type \App\Lib\Unifaun\StructType\ConsignmentReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConsignmentReference value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ConsignmentReference[] $consignmentReference
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setConsignmentReference(array $consignmentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentReferenceArrayErrorMessage = self::validateConsignmentReferenceForArrayConstraintsFromSetConsignmentReference($consignmentReference))) {
            throw new \InvalidArgumentException($consignmentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ConsignmentReference = $consignmentReference;
        return $this;
    }
    /**
     * Add item to ConsignmentReference value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ConsignmentReference $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToConsignmentReference(\App\Lib\Unifaun\StructType\ConsignmentReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ConsignmentReference) {
            throw new \InvalidArgumentException(sprintf('The ConsignmentReference property can only contain items of type \App\Lib\Unifaun\StructType\ConsignmentReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ConsignmentReference[] = $item;
        return $this;
    }
    /**
     * Get Note value
     * @return \App\Lib\Unifaun\StructType\Note[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentNoteItem) {
            // validation for constraint: itemType
            if (!$consignmentNoteItem instanceof \App\Lib\Unifaun\StructType\Note) {
                $invalidValues[] = is_object($consignmentNoteItem) ? get_class($consignmentNoteItem) : sprintf('%s(%s)', gettype($consignmentNoteItem), var_export($consignmentNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note property can only contain items of type \App\Lib\Unifaun\StructType\Note, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Note[] $note
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new \InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Note $item
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function addToNote(\App\Lib\Unifaun\StructType\Note $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Note) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of type \App\Lib\Unifaun\StructType\Note, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get GoodsInvoice value
     * @return \App\Lib\Unifaun\StructType\GoodsInvoice|null
     */
    public function getGoodsInvoice()
    {
        return $this->GoodsInvoice;
    }
    /**
     * Set GoodsInvoice value
     * @param \App\Lib\Unifaun\StructType\GoodsInvoice $goodsInvoice
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setGoodsInvoice(\App\Lib\Unifaun\StructType\GoodsInvoice $goodsInvoice = null)
    {
        $this->GoodsInvoice = $goodsInvoice;
        return $this;
    }
    /**
     * Get orderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @param string $orderType
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderType, true), gettype($orderType)), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Get automaticBooking value
     * @return string|null
     */
    public function getAutomaticBooking()
    {
        return $this->automaticBooking;
    }
    /**
     * Set automaticBooking value
     * @param string $automaticBooking
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setAutomaticBooking($automaticBooking = null)
    {
        // validation for constraint: string
        if (!is_null($automaticBooking) && !is_string($automaticBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($automaticBooking, true), gettype($automaticBooking)), __LINE__);
        }
        $this->automaticBooking = $automaticBooking;
        return $this;
    }
    /**
     * Get consignmentId value
     * @return string|null
     */
    public function getConsignmentId()
    {
        return $this->consignmentId;
    }
    /**
     * Set consignmentId value
     * @param string $consignmentId
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setConsignmentId($consignmentId = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentId) && !is_string($consignmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentId, true), gettype($consignmentId)), __LINE__);
        }
        $this->consignmentId = $consignmentId;
        return $this;
    }
    /**
     * Get consignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->consignmentNo;
    }
    /**
     * Set consignmentNo value
     * @param string $consignmentNo
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNo, true), gettype($consignmentNo)), __LINE__);
        }
        $this->consignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get templateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->templateName;
    }
    /**
     * Set templateName value
     * @param string $templateName
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateName, true), gettype($templateName)), __LINE__);
        }
        $this->templateName = $templateName;
        return $this;
    }
    /**
     * Get owner value
     * @return string|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param string $owner
     * @return \App\Lib\Unifaun\StructType\Consignment
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        $this->owner = $owner;
        return $this;
    }
}
