<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Copy ServiceType
 * @subpackage Services
 */
class Copy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named copy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\Copy $parameters
     * @return \App\Lib\Unifaun\StructType\CopyResponse|bool
     */
    public function copy(\App\Lib\Unifaun\StructType\Copy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->copy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\CopyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
