<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getTransactionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\GetTransactionId $parameters
     * @return \App\Lib\Unifaun\StructType\GetTransactionIdResponse|bool
     */
    public function getTransactionId(\App\Lib\Unifaun\StructType\GetTransactionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTransactionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCalculatedPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\GetCalculatedPrice $parameters
     * @return \App\Lib\Unifaun\StructType\GetCalculatedPriceResponse|bool
     */
    public function getCalculatedPrice(\App\Lib\Unifaun\StructType\GetCalculatedPrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCalculatedPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConsignmentTemplates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\GetConsignmentTemplates $parameters
     * @return \App\Lib\Unifaun\StructType\GetConsignmentTemplatesResponse|bool
     */
    public function getConsignmentTemplates(\App\Lib\Unifaun\StructType\GetConsignmentTemplates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getConsignmentTemplates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\GetCalculatedPriceResponse|\App\Lib\Unifaun\StructType\GetConsignmentTemplatesResponse|\App\Lib\Unifaun\StructType\GetTransactionIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
