<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findByConsignmentId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\FindByConsignmentId $parameters
     * @return \App\Lib\Unifaun\StructType\FindByConsignmentIdResponse|bool
     */
    public function findByConsignmentId(\App\Lib\Unifaun\StructType\FindByConsignmentId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByConsignmentId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findByConsignmentNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\FindByConsignmentNo $parameters
     * @return \App\Lib\Unifaun\StructType\FindByConsignmentNoResponse|bool
     */
    public function findByConsignmentNo(\App\Lib\Unifaun\StructType\FindByConsignmentNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByConsignmentNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findByConsignorReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\FindByConsignorReference $parameters
     * @return \App\Lib\Unifaun\StructType\FindByConsignorReferenceResponse|bool
     */
    public function findByConsignorReference(\App\Lib\Unifaun\StructType\FindByConsignorReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByConsignorReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\FindById $parameters
     * @return \App\Lib\Unifaun\StructType\FindByIdResponse|bool
     */
    public function findById(\App\Lib\Unifaun\StructType\FindById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findByPackageId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\FindByPackageId $parameters
     * @return \App\Lib\Unifaun\StructType\FindByPackageIdResponse|bool
     */
    public function findByPackageId(\App\Lib\Unifaun\StructType\FindByPackageId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByPackageId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findByReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\FindByReference $parameters
     * @return \App\Lib\Unifaun\StructType\FindByReferenceResponse|bool
     */
    public function findByReference(\App\Lib\Unifaun\StructType\FindByReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findByTransactionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\FindByTransactionId $parameters
     * @return \App\Lib\Unifaun\StructType\FindByTransactionIdResponse|bool
     */
    public function findByTransactionId(\App\Lib\Unifaun\StructType\FindByTransactionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findByTransactionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\FindByConsignmentIdResponse|\App\Lib\Unifaun\StructType\FindByConsignmentNoResponse|\App\Lib\Unifaun\StructType\FindByConsignorReferenceResponse|\App\Lib\Unifaun\StructType\FindByIdResponse|\App\Lib\Unifaun\StructType\FindByPackageIdResponse|\App\Lib\Unifaun\StructType\FindByReferenceResponse|\App\Lib\Unifaun\StructType\FindByTransactionIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
