<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsignmentResult StructType
 * @subpackage Structs
 */
class ConsignmentResult extends AbstractStructBase
{
    /**
     * The consignments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Consignment[]
     */
    public $consignments;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Error[]
     */
    public $errors;
    /**
     * The documents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Document[]
     */
    public $documents;
    /**
     * The receipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Receipt
     */
    public $receipt;
    /**
     * The statusCode
     * @var int
     */
    public $statusCode;
    /**
     * Constructor method for ConsignmentResult
     * @uses ConsignmentResult::setConsignments()
     * @uses ConsignmentResult::setErrors()
     * @uses ConsignmentResult::setDocuments()
     * @uses ConsignmentResult::setReceipt()
     * @uses ConsignmentResult::setStatusCode()
     * @param \App\Lib\Unifaun\StructType\Consignment[] $consignments
     * @param \App\Lib\Unifaun\StructType\Error[] $errors
     * @param \App\Lib\Unifaun\StructType\Document[] $documents
     * @param \App\Lib\Unifaun\StructType\Receipt $receipt
     * @param int $statusCode
     */
    public function __construct(array $consignments = array(), array $errors = array(), array $documents = array(), \App\Lib\Unifaun\StructType\Receipt $receipt = null, $statusCode = null)
    {
        $this
            ->setConsignments($consignments)
            ->setErrors($errors)
            ->setDocuments($documents)
            ->setReceipt($receipt)
            ->setStatusCode($statusCode);
    }
    /**
     * Get consignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Consignment[]|null
     */
    public function getConsignments()
    {
        return isset($this->consignments) ? $this->consignments : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentsForArrayConstraintsFromSetConsignments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentResultConsignmentsItem) {
            // validation for constraint: itemType
            if (!$consignmentResultConsignmentsItem instanceof \App\Lib\Unifaun\StructType\Consignment) {
                $invalidValues[] = is_object($consignmentResultConsignmentsItem) ? get_class($consignmentResultConsignmentsItem) : sprintf('%s(%s)', gettype($consignmentResultConsignmentsItem), var_export($consignmentResultConsignmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignments property can only contain items of type \App\Lib\Unifaun\StructType\Consignment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Consignment[] $consignments
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setConsignments(array $consignments = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentsArrayErrorMessage = self::validateConsignmentsForArrayConstraintsFromSetConsignments($consignments))) {
            throw new \InvalidArgumentException($consignmentsArrayErrorMessage, __LINE__);
        }
        if (is_null($consignments) || (is_array($consignments) && empty($consignments))) {
            unset($this->consignments);
        } else {
            $this->consignments = $consignments;
        }
        return $this;
    }
    /**
     * Add item to consignments value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Consignment $item
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function addToConsignments(\App\Lib\Unifaun\StructType\Consignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Consignment) {
            throw new \InvalidArgumentException(sprintf('The consignments property can only contain items of type \App\Lib\Unifaun\StructType\Consignment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->consignments[] = $item;
        return $this;
    }
    /**
     * Get errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Error[]|null
     */
    public function getErrors()
    {
        return isset($this->errors) ? $this->errors : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorsForArrayConstraintsFromSetErrors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentResultErrorsItem) {
            // validation for constraint: itemType
            if (!$consignmentResultErrorsItem instanceof \App\Lib\Unifaun\StructType\Error) {
                $invalidValues[] = is_object($consignmentResultErrorsItem) ? get_class($consignmentResultErrorsItem) : sprintf('%s(%s)', gettype($consignmentResultErrorsItem), var_export($consignmentResultErrorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The errors property can only contain items of type \App\Lib\Unifaun\StructType\Error, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Error[] $errors
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setErrors(array $errors = array())
    {
        // validation for constraint: array
        if ('' !== ($errorsArrayErrorMessage = self::validateErrorsForArrayConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsArrayErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->errors);
        } else {
            $this->errors = $errors;
        }
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Error $item
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function addToErrors(\App\Lib\Unifaun\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of type \App\Lib\Unifaun\StructType\Error, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Get documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Document[]|null
     */
    public function getDocuments()
    {
        return isset($this->documents) ? $this->documents : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocuments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocuments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsForArrayConstraintsFromSetDocuments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentResultDocumentsItem) {
            // validation for constraint: itemType
            if (!$consignmentResultDocumentsItem instanceof \App\Lib\Unifaun\StructType\Document) {
                $invalidValues[] = is_object($consignmentResultDocumentsItem) ? get_class($consignmentResultDocumentsItem) : sprintf('%s(%s)', gettype($consignmentResultDocumentsItem), var_export($consignmentResultDocumentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The documents property can only contain items of type \App\Lib\Unifaun\StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Document[] $documents
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setDocuments(array $documents = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsArrayErrorMessage = self::validateDocumentsForArrayConstraintsFromSetDocuments($documents))) {
            throw new \InvalidArgumentException($documentsArrayErrorMessage, __LINE__);
        }
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->documents);
        } else {
            $this->documents = $documents;
        }
        return $this;
    }
    /**
     * Add item to documents value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Document $item
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function addToDocuments(\App\Lib\Unifaun\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The documents property can only contain items of type \App\Lib\Unifaun\StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->documents[] = $item;
        return $this;
    }
    /**
     * Get receipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Receipt|null
     */
    public function getReceipt()
    {
        return isset($this->receipt) ? $this->receipt : null;
    }
    /**
     * Set receipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Lib\Unifaun\StructType\Receipt $receipt
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setReceipt(\App\Lib\Unifaun\StructType\Receipt $receipt = null)
    {
        if (is_null($receipt) || (is_array($receipt) && empty($receipt))) {
            unset($this->receipt);
        } else {
            $this->receipt = $receipt;
        }
        return $this;
    }
    /**
     * Get statusCode value
     * @return int|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param int $statusCode
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\ConsignmentResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
