<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named isArchived
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\IsArchived $parameters
     * @return \App\Lib\Unifaun\StructType\IsArchivedResponse|bool
     */
    public function isArchived(\App\Lib\Unifaun\StructType\IsArchived $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isArchived($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isBooked
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\IsBooked $parameters
     * @return \App\Lib\Unifaun\StructType\IsBookedResponse|bool
     */
    public function isBooked(\App\Lib\Unifaun\StructType\IsBooked $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isBooked($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isComplete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\IsComplete $parameters
     * @return \App\Lib\Unifaun\StructType\IsCompleteResponse|bool
     */
    public function isComplete(\App\Lib\Unifaun\StructType\IsComplete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isComplete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isOrdered
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\IsOrdered $parameters
     * @return \App\Lib\Unifaun\StructType\IsOrderedResponse|bool
     */
    public function isOrdered(\App\Lib\Unifaun\StructType\IsOrdered $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isOrdered($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isPrintable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\IsPrintable $parameters
     * @return \App\Lib\Unifaun\StructType\IsPrintableResponse|bool
     */
    public function isPrintable(\App\Lib\Unifaun\StructType\IsPrintable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isPrintable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isPrinted
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\IsPrinted $parameters
     * @return \App\Lib\Unifaun\StructType\IsPrintedResponse|bool
     */
    public function isPrinted(\App\Lib\Unifaun\StructType\IsPrinted $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isPrinted($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\IsArchivedResponse|\App\Lib\Unifaun\StructType\IsBookedResponse|\App\Lib\Unifaun\StructType\IsCompleteResponse|\App\Lib\Unifaun\StructType\IsOrderedResponse|\App\Lib\Unifaun\StructType\IsPrintableResponse|\App\Lib\Unifaun\StructType\IsPrintedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
