<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transport StructType
 * @subpackage Structs
 */
class Transport extends AbstractStructBase
{
    /**
     * The instruction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:instruction
     * @var string[]
     */
    public $instruction;
    /**
     * The cooling
     * Meta information extracted from the WSDL
     * - choice: cooling | heating | frozen
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - ref: tns:cooling
     * @var bool
     */
    public $cooling;
    /**
     * The heating
     * Meta information extracted from the WSDL
     * - choice: cooling | heating | frozen
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - ref: tns:heating
     * @var bool
     */
    public $heating;
    /**
     * The frozen
     * Meta information extracted from the WSDL
     * - choice: cooling | heating | frozen
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - ref: tns:frozen
     * @var bool
     */
    public $frozen;
    /**
     * The tempLow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:tempLow
     * @var int
     */
    public $tempLow;
    /**
     * The tempHigh
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:tempHigh
     * @var int
     */
    public $tempHigh;
    /**
     * The subsidyNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:subsidyNo
     * @var string
     */
    public $subsidyNo;
    /**
     * The valuableGoods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:valuableGoods
     * @var bool
     */
    public $valuableGoods;
    /**
     * The carryIn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:carryIn
     * @var bool
     */
    public $carryIn;
    /**
     * The extraCrew
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:extraCrew
     * @var bool
     */
    public $extraCrew;
    /**
     * The eurPallets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:eurPallets
     * @var int
     */
    public $eurPallets;
    /**
     * The limitedQuantityDangerousGoods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:limitedQuantityDangerousGoods
     * @var bool
     */
    public $limitedQuantityDangerousGoods;
    /**
     * Constructor method for Transport
     * @uses Transport::setInstruction()
     * @uses Transport::setCooling()
     * @uses Transport::setHeating()
     * @uses Transport::setFrozen()
     * @uses Transport::setTempLow()
     * @uses Transport::setTempHigh()
     * @uses Transport::setSubsidyNo()
     * @uses Transport::setValuableGoods()
     * @uses Transport::setCarryIn()
     * @uses Transport::setExtraCrew()
     * @uses Transport::setEurPallets()
     * @uses Transport::setLimitedQuantityDangerousGoods()
     * @param string[] $instruction
     * @param bool $cooling
     * @param bool $heating
     * @param bool $frozen
     * @param int $tempLow
     * @param int $tempHigh
     * @param string $subsidyNo
     * @param bool $valuableGoods
     * @param bool $carryIn
     * @param bool $extraCrew
     * @param int $eurPallets
     * @param bool $limitedQuantityDangerousGoods
     */
    public function __construct(array $instruction = array(), $cooling = null, $heating = null, $frozen = null, $tempLow = null, $tempHigh = null, $subsidyNo = null, $valuableGoods = null, $carryIn = null, $extraCrew = null, $eurPallets = null, $limitedQuantityDangerousGoods = null)
    {
        $this
            ->setInstruction($instruction)
            ->setCooling($cooling)
            ->setHeating($heating)
            ->setFrozen($frozen)
            ->setTempLow($tempLow)
            ->setTempHigh($tempHigh)
            ->setSubsidyNo($subsidyNo)
            ->setValuableGoods($valuableGoods)
            ->setCarryIn($carryIn)
            ->setExtraCrew($extraCrew)
            ->setEurPallets($eurPallets)
            ->setLimitedQuantityDangerousGoods($limitedQuantityDangerousGoods);
    }
    /**
     * Get instruction value
     * @return string[]|null
     */
    public function getInstruction()
    {
        return $this->instruction;
    }
    /**
     * This method is responsible for validating the values passed to the setInstruction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstruction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionForArrayConstraintsFromSetInstruction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportInstructionItem) {
            // validation for constraint: itemType
            if (!is_string($transportInstructionItem)) {
                $invalidValues[] = is_object($transportInstructionItem) ? get_class($transportInstructionItem) : sprintf('%s(%s)', gettype($transportInstructionItem), var_export($transportInstructionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The instruction property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set instruction value
     * @throws \InvalidArgumentException
     * @param string[] $instruction
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setInstruction(array $instruction = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionArrayErrorMessage = self::validateInstructionForArrayConstraintsFromSetInstruction($instruction))) {
            throw new \InvalidArgumentException($instructionArrayErrorMessage, __LINE__);
        }
        $this->instruction = $instruction;
        return $this;
    }
    /**
     * Add item to instruction value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function addToInstruction($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The instruction property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->instruction[] = $item;
        return $this;
    }
    /**
     * Get cooling value
     * @return bool|null
     */
    public function getCooling()
    {
        return isset($this->cooling) ? $this->cooling : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCooling method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCooling method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCoolingForChoiceConstraintsFromSetCooling($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'heating',
            'frozen',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property cooling can\'t be set as the property %s is already set. Only one property must be set among these properties: cooling, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set cooling value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $cooling
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setCooling($cooling = null)
    {
        // validation for constraint: boolean
        if (!is_null($cooling) && !is_bool($cooling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cooling, true), gettype($cooling)), __LINE__);
        }
        // validation for constraint: choice(cooling, heating, frozen)
        if ('' !== ($coolingChoiceErrorMessage = self::validateCoolingForChoiceConstraintsFromSetCooling($cooling))) {
            throw new \InvalidArgumentException($coolingChoiceErrorMessage, __LINE__);
        }
        if (is_null($cooling) || (is_array($cooling) && empty($cooling))) {
            unset($this->cooling);
        } else {
            $this->cooling = $cooling;
        }
        return $this;
    }
    /**
     * Get heating value
     * @return bool|null
     */
    public function getHeating()
    {
        return isset($this->heating) ? $this->heating : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHeating method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHeating method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHeatingForChoiceConstraintsFromSetHeating($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'cooling',
            'frozen',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property heating can\'t be set as the property %s is already set. Only one property must be set among these properties: heating, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set heating value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $heating
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setHeating($heating = null)
    {
        // validation for constraint: boolean
        if (!is_null($heating) && !is_bool($heating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($heating, true), gettype($heating)), __LINE__);
        }
        // validation for constraint: choice(cooling, heating, frozen)
        if ('' !== ($heatingChoiceErrorMessage = self::validateHeatingForChoiceConstraintsFromSetHeating($heating))) {
            throw new \InvalidArgumentException($heatingChoiceErrorMessage, __LINE__);
        }
        if (is_null($heating) || (is_array($heating) && empty($heating))) {
            unset($this->heating);
        } else {
            $this->heating = $heating;
        }
        return $this;
    }
    /**
     * Get frozen value
     * @return bool|null
     */
    public function getFrozen()
    {
        return isset($this->frozen) ? $this->frozen : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFrozen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFrozen method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFrozenForChoiceConstraintsFromSetFrozen($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'cooling',
            'heating',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property frozen can\'t be set as the property %s is already set. Only one property must be set among these properties: frozen, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set frozen value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $frozen
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setFrozen($frozen = null)
    {
        // validation for constraint: boolean
        if (!is_null($frozen) && !is_bool($frozen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($frozen, true), gettype($frozen)), __LINE__);
        }
        // validation for constraint: choice(cooling, heating, frozen)
        if ('' !== ($frozenChoiceErrorMessage = self::validateFrozenForChoiceConstraintsFromSetFrozen($frozen))) {
            throw new \InvalidArgumentException($frozenChoiceErrorMessage, __LINE__);
        }
        if (is_null($frozen) || (is_array($frozen) && empty($frozen))) {
            unset($this->frozen);
        } else {
            $this->frozen = $frozen;
        }
        return $this;
    }
    /**
     * Get tempLow value
     * @return int|null
     */
    public function getTempLow()
    {
        return $this->tempLow;
    }
    /**
     * Set tempLow value
     * @param int $tempLow
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setTempLow($tempLow = null)
    {
        // validation for constraint: int
        if (!is_null($tempLow) && !(is_int($tempLow) || ctype_digit($tempLow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tempLow, true), gettype($tempLow)), __LINE__);
        }
        $this->tempLow = $tempLow;
        return $this;
    }
    /**
     * Get tempHigh value
     * @return int|null
     */
    public function getTempHigh()
    {
        return $this->tempHigh;
    }
    /**
     * Set tempHigh value
     * @param int $tempHigh
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setTempHigh($tempHigh = null)
    {
        // validation for constraint: int
        if (!is_null($tempHigh) && !(is_int($tempHigh) || ctype_digit($tempHigh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tempHigh, true), gettype($tempHigh)), __LINE__);
        }
        $this->tempHigh = $tempHigh;
        return $this;
    }
    /**
     * Get subsidyNo value
     * @return string|null
     */
    public function getSubsidyNo()
    {
        return $this->subsidyNo;
    }
    /**
     * Set subsidyNo value
     * @param string $subsidyNo
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setSubsidyNo($subsidyNo = null)
    {
        // validation for constraint: string
        if (!is_null($subsidyNo) && !is_string($subsidyNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidyNo, true), gettype($subsidyNo)), __LINE__);
        }
        $this->subsidyNo = $subsidyNo;
        return $this;
    }
    /**
     * Get valuableGoods value
     * @return bool|null
     */
    public function getValuableGoods()
    {
        return $this->valuableGoods;
    }
    /**
     * Set valuableGoods value
     * @param bool $valuableGoods
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setValuableGoods($valuableGoods = null)
    {
        // validation for constraint: boolean
        if (!is_null($valuableGoods) && !is_bool($valuableGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valuableGoods, true), gettype($valuableGoods)), __LINE__);
        }
        $this->valuableGoods = $valuableGoods;
        return $this;
    }
    /**
     * Get carryIn value
     * @return bool|null
     */
    public function getCarryIn()
    {
        return $this->carryIn;
    }
    /**
     * Set carryIn value
     * @param bool $carryIn
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setCarryIn($carryIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($carryIn) && !is_bool($carryIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($carryIn, true), gettype($carryIn)), __LINE__);
        }
        $this->carryIn = $carryIn;
        return $this;
    }
    /**
     * Get extraCrew value
     * @return bool|null
     */
    public function getExtraCrew()
    {
        return $this->extraCrew;
    }
    /**
     * Set extraCrew value
     * @param bool $extraCrew
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setExtraCrew($extraCrew = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraCrew) && !is_bool($extraCrew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extraCrew, true), gettype($extraCrew)), __LINE__);
        }
        $this->extraCrew = $extraCrew;
        return $this;
    }
    /**
     * Get eurPallets value
     * @return int|null
     */
    public function getEurPallets()
    {
        return $this->eurPallets;
    }
    /**
     * Set eurPallets value
     * @param int $eurPallets
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setEurPallets($eurPallets = null)
    {
        // validation for constraint: int
        if (!is_null($eurPallets) && !(is_int($eurPallets) || ctype_digit($eurPallets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eurPallets, true), gettype($eurPallets)), __LINE__);
        }
        $this->eurPallets = $eurPallets;
        return $this;
    }
    /**
     * Get limitedQuantityDangerousGoods value
     * @return bool|null
     */
    public function getLimitedQuantityDangerousGoods()
    {
        return $this->limitedQuantityDangerousGoods;
    }
    /**
     * Set limitedQuantityDangerousGoods value
     * @param bool $limitedQuantityDangerousGoods
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setLimitedQuantityDangerousGoods($limitedQuantityDangerousGoods = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitedQuantityDangerousGoods) && !is_bool($limitedQuantityDangerousGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($limitedQuantityDangerousGoods, true), gettype($limitedQuantityDangerousGoods)), __LINE__);
        }
        $this->limitedQuantityDangerousGoods = $limitedQuantityDangerousGoods;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
