<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Target StructType
 * @subpackage Structs
 */
class Target extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - ref: tns:date
     * @var string
     */
    public $date;
    /**
     * The earliest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:earliest
     * @var string
     */
    public $earliest;
    /**
     * The latest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:latest
     * @var string
     */
    public $latest;
    /**
     * Constructor method for Target
     * @uses Target::setDate()
     * @uses Target::setEarliest()
     * @uses Target::setLatest()
     * @param string $date
     * @param string $earliest
     * @param string $latest
     */
    public function __construct($date = null, $earliest = null, $latest = null)
    {
        $this
            ->setDate($date)
            ->setEarliest($earliest)
            ->setLatest($latest);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \App\Lib\Unifaun\StructType\Target
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get earliest value
     * @return string|null
     */
    public function getEarliest()
    {
        return $this->earliest;
    }
    /**
     * Set earliest value
     * @param string $earliest
     * @return \App\Lib\Unifaun\StructType\Target
     */
    public function setEarliest($earliest = null)
    {
        // validation for constraint: string
        if (!is_null($earliest) && !is_string($earliest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliest, true), gettype($earliest)), __LINE__);
        }
        $this->earliest = $earliest;
        return $this;
    }
    /**
     * Get latest value
     * @return string|null
     */
    public function getLatest()
    {
        return $this->latest;
    }
    /**
     * Set latest value
     * @param string $latest
     * @return \App\Lib\Unifaun\StructType\Target
     */
    public function setLatest($latest = null)
    {
        // validation for constraint: string
        if (!is_null($latest) && !is_string($latest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latest, true), gettype($latest)), __LINE__);
        }
        $this->latest = $latest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Target
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
