<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for print StructType
 * Meta information extracted from the WSDL
 * - type: tns:print
 * @subpackage Structs
 */
class _print extends AbstractStructBase
{
    /**
     * The AuthenticationToken
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\AuthenticationToken
     */
    public $AuthenticationToken;
    /**
     * The arrayOfConsignmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $arrayOfConsignmentNo;
    /**
     * The type
     * @var int
     */
    public $type;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $format;
    /**
     * Constructor method for print
     * @uses _print::setAuthenticationToken()
     * @uses _print::setArrayOfConsignmentNo()
     * @uses _print::setType()
     * @uses _print::setFormat()
     * @param \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken
     * @param string[] $arrayOfConsignmentNo
     * @param int $type
     * @param string $format
     */
    public function __construct(\App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken = null, array $arrayOfConsignmentNo = array(), $type = null, $format = null)
    {
        $this
            ->setAuthenticationToken($authenticationToken)
            ->setArrayOfConsignmentNo($arrayOfConsignmentNo)
            ->setType($type)
            ->setFormat($format);
    }
    /**
     * Get AuthenticationToken value
     * @return \App\Lib\Unifaun\StructType\AuthenticationToken|null
     */
    public function getAuthenticationToken()
    {
        return $this->AuthenticationToken;
    }
    /**
     * Set AuthenticationToken value
     * @param \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken
     * @return \App\Lib\Unifaun\StructType\_print
     */
    public function setAuthenticationToken(\App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken = null)
    {
        $this->AuthenticationToken = $authenticationToken;
        return $this;
    }
    /**
     * Get arrayOfConsignmentNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getArrayOfConsignmentNo()
    {
        return isset($this->arrayOfConsignmentNo) ? $this->arrayOfConsignmentNo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArrayOfConsignmentNo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArrayOfConsignmentNo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArrayOfConsignmentNoForArrayConstraintsFromSetArrayOfConsignmentNo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $printArrayOfConsignmentNoItem) {
            // validation for constraint: itemType
            if (!is_string($printArrayOfConsignmentNoItem)) {
                $invalidValues[] = is_object($printArrayOfConsignmentNoItem) ? get_class($printArrayOfConsignmentNoItem) : sprintf('%s(%s)', gettype($printArrayOfConsignmentNoItem), var_export($printArrayOfConsignmentNoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The arrayOfConsignmentNo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set arrayOfConsignmentNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $arrayOfConsignmentNo
     * @return \App\Lib\Unifaun\StructType\_print
     */
    public function setArrayOfConsignmentNo(array $arrayOfConsignmentNo = array())
    {
        // validation for constraint: array
        if ('' !== ($arrayOfConsignmentNoArrayErrorMessage = self::validateArrayOfConsignmentNoForArrayConstraintsFromSetArrayOfConsignmentNo($arrayOfConsignmentNo))) {
            throw new \InvalidArgumentException($arrayOfConsignmentNoArrayErrorMessage, __LINE__);
        }
        if (is_null($arrayOfConsignmentNo) || (is_array($arrayOfConsignmentNo) && empty($arrayOfConsignmentNo))) {
            unset($this->arrayOfConsignmentNo);
        } else {
            $this->arrayOfConsignmentNo = $arrayOfConsignmentNo;
        }
        return $this;
    }
    /**
     * Add item to arrayOfConsignmentNo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\_print
     */
    public function addToArrayOfConsignmentNo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The arrayOfConsignmentNo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->arrayOfConsignmentNo[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \App\Lib\Unifaun\StructType\_print
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \App\Lib\Unifaun\StructType\_print
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\_print
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
