<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationToken StructType
 * @subpackage Structs
 */
class AuthenticationToken extends AbstractStructBase
{
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The groupName
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $groupName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * Constructor method for AuthenticationToken
     * @uses AuthenticationToken::setUserName()
     * @uses AuthenticationToken::setGroupName()
     * @uses AuthenticationToken::setPassword()
     * @param string $userName
     * @param string $groupName
     * @param string $password
     */
    public function __construct($userName = null, $groupName = null, $password = null)
    {
        $this
            ->setUserName($userName)
            ->setGroupName($groupName)
            ->setPassword($password);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \App\Lib\Unifaun\StructType\AuthenticationToken
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get groupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \App\Lib\Unifaun\StructType\AuthenticationToken
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \App\Lib\Unifaun\StructType\AuthenticationToken
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\AuthenticationToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
