<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pickup StructType
 * @subpackage Structs
 */
class Pickup extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:date
     * @var string
     */
    public $date;
    /**
     * The earliest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:earliest
     * @var string
     */
    public $earliest;
    /**
     * The latest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:latest
     * @var string
     */
    public $latest;
    /**
     * The instruction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:instruction
     * @var string[]
     */
    public $instruction;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:location
     * @var string
     */
    public $location;
    /**
     * Constructor method for Pickup
     * @uses Pickup::setDate()
     * @uses Pickup::setEarliest()
     * @uses Pickup::setLatest()
     * @uses Pickup::setInstruction()
     * @uses Pickup::setLocation()
     * @param string $date
     * @param string $earliest
     * @param string $latest
     * @param string[] $instruction
     * @param string $location
     */
    public function __construct($date = null, $earliest = null, $latest = null, array $instruction = array(), $location = null)
    {
        $this
            ->setDate($date)
            ->setEarliest($earliest)
            ->setLatest($latest)
            ->setInstruction($instruction)
            ->setLocation($location);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \App\Lib\Unifaun\StructType\Pickup
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get earliest value
     * @return string|null
     */
    public function getEarliest()
    {
        return $this->earliest;
    }
    /**
     * Set earliest value
     * @param string $earliest
     * @return \App\Lib\Unifaun\StructType\Pickup
     */
    public function setEarliest($earliest = null)
    {
        // validation for constraint: string
        if (!is_null($earliest) && !is_string($earliest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliest, true), gettype($earliest)), __LINE__);
        }
        $this->earliest = $earliest;
        return $this;
    }
    /**
     * Get latest value
     * @return string|null
     */
    public function getLatest()
    {
        return $this->latest;
    }
    /**
     * Set latest value
     * @param string $latest
     * @return \App\Lib\Unifaun\StructType\Pickup
     */
    public function setLatest($latest = null)
    {
        // validation for constraint: string
        if (!is_null($latest) && !is_string($latest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latest, true), gettype($latest)), __LINE__);
        }
        $this->latest = $latest;
        return $this;
    }
    /**
     * Get instruction value
     * @return string[]|null
     */
    public function getInstruction()
    {
        return $this->instruction;
    }
    /**
     * This method is responsible for validating the values passed to the setInstruction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstruction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionForArrayConstraintsFromSetInstruction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pickupInstructionItem) {
            // validation for constraint: itemType
            if (!is_string($pickupInstructionItem)) {
                $invalidValues[] = is_object($pickupInstructionItem) ? get_class($pickupInstructionItem) : sprintf('%s(%s)', gettype($pickupInstructionItem), var_export($pickupInstructionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The instruction property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set instruction value
     * @throws \InvalidArgumentException
     * @param string[] $instruction
     * @return \App\Lib\Unifaun\StructType\Pickup
     */
    public function setInstruction(array $instruction = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionArrayErrorMessage = self::validateInstructionForArrayConstraintsFromSetInstruction($instruction))) {
            throw new \InvalidArgumentException($instructionArrayErrorMessage, __LINE__);
        }
        $this->instruction = $instruction;
        return $this;
    }
    /**
     * Add item to instruction value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\Pickup
     */
    public function addToInstruction($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The instruction property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->instruction[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \App\Lib\Unifaun\StructType\Pickup
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Pickup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
