<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tod StructType
 * @subpackage Structs
 */
class Tod extends AbstractStructBase
{
    /**
     * The combiterm
     * Meta information extracted from the WSDL
     * - ref: tns:combiterm
     * @var string
     */
    public $combiterm;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - ref: tns:location
     * @var string
     */
    public $location;
    /**
     * The countrycode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:countrycode
     * @var string
     */
    public $countrycode;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:notes
     * @var string
     */
    public $notes;
    /**
     * Constructor method for Tod
     * @uses Tod::setCombiterm()
     * @uses Tod::setLocation()
     * @uses Tod::setCountrycode()
     * @uses Tod::setNotes()
     * @param string $combiterm
     * @param string $location
     * @param string $countrycode
     * @param string $notes
     */
    public function __construct($combiterm = null, $location = null, $countrycode = null, $notes = null)
    {
        $this
            ->setCombiterm($combiterm)
            ->setLocation($location)
            ->setCountrycode($countrycode)
            ->setNotes($notes);
    }
    /**
     * Get combiterm value
     * @return string|null
     */
    public function getCombiterm()
    {
        return $this->combiterm;
    }
    /**
     * Set combiterm value
     * @param string $combiterm
     * @return \App\Lib\Unifaun\StructType\Tod
     */
    public function setCombiterm($combiterm = null)
    {
        // validation for constraint: string
        if (!is_null($combiterm) && !is_string($combiterm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combiterm, true), gettype($combiterm)), __LINE__);
        }
        $this->combiterm = $combiterm;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \App\Lib\Unifaun\StructType\Tod
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get countrycode value
     * @return string|null
     */
    public function getCountrycode()
    {
        return $this->countrycode;
    }
    /**
     * Set countrycode value
     * @param string $countrycode
     * @return \App\Lib\Unifaun\StructType\Tod
     */
    public function setCountrycode($countrycode = null)
    {
        // validation for constraint: string
        if (!is_null($countrycode) && !is_string($countrycode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrycode, true), gettype($countrycode)), __LINE__);
        }
        $this->countrycode = $countrycode;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \App\Lib\Unifaun\StructType\Tod
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Tod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
