<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt StructType
 * @subpackage Structs
 */
class Receipt extends AbstractStructBase
{
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $URL;
    /**
     * The HTML
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $HTML;
    /**
     * The PDF
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Document
     */
    public $PDF;
    /**
     * The resources
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Document[]
     */
    public $resources;
    /**
     * Constructor method for Receipt
     * @uses Receipt::setURL()
     * @uses Receipt::setHTML()
     * @uses Receipt::setPDF()
     * @uses Receipt::setResources()
     * @param string $uRL
     * @param string $hTML
     * @param \App\Lib\Unifaun\StructType\Document $pDF
     * @param \App\Lib\Unifaun\StructType\Document[] $resources
     */
    public function __construct($uRL = null, $hTML = null, \App\Lib\Unifaun\StructType\Document $pDF = null, array $resources = array())
    {
        $this
            ->setURL($uRL)
            ->setHTML($hTML)
            ->setPDF($pDF)
            ->setResources($resources);
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \App\Lib\Unifaun\StructType\Receipt
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get HTML value
     * @return string|null
     */
    public function getHTML()
    {
        return $this->HTML;
    }
    /**
     * Set HTML value
     * @param string $hTML
     * @return \App\Lib\Unifaun\StructType\Receipt
     */
    public function setHTML($hTML = null)
    {
        // validation for constraint: string
        if (!is_null($hTML) && !is_string($hTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTML, true), gettype($hTML)), __LINE__);
        }
        $this->HTML = $hTML;
        return $this;
    }
    /**
     * Get PDF value
     * @return \App\Lib\Unifaun\StructType\Document|null
     */
    public function getPDF()
    {
        return $this->PDF;
    }
    /**
     * Set PDF value
     * @param \App\Lib\Unifaun\StructType\Document $pDF
     * @return \App\Lib\Unifaun\StructType\Receipt
     */
    public function setPDF(\App\Lib\Unifaun\StructType\Document $pDF = null)
    {
        $this->PDF = $pDF;
        return $this;
    }
    /**
     * Get resources value
     * @return \App\Lib\Unifaun\StructType\Document[]|null
     */
    public function getResources()
    {
        return $this->resources;
    }
    /**
     * This method is responsible for validating the values passed to the setResources method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResources method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResourcesForArrayConstraintsFromSetResources(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receiptResourcesItem) {
            // validation for constraint: itemType
            if (!$receiptResourcesItem instanceof \App\Lib\Unifaun\StructType\Document) {
                $invalidValues[] = is_object($receiptResourcesItem) ? get_class($receiptResourcesItem) : sprintf('%s(%s)', gettype($receiptResourcesItem), var_export($receiptResourcesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The resources property can only contain items of type \App\Lib\Unifaun\StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set resources value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Document[] $resources
     * @return \App\Lib\Unifaun\StructType\Receipt
     */
    public function setResources(array $resources = array())
    {
        // validation for constraint: array
        if ('' !== ($resourcesArrayErrorMessage = self::validateResourcesForArrayConstraintsFromSetResources($resources))) {
            throw new \InvalidArgumentException($resourcesArrayErrorMessage, __LINE__);
        }
        $this->resources = $resources;
        return $this;
    }
    /**
     * Add item to resources value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Document $item
     * @return \App\Lib\Unifaun\StructType\Receipt
     */
    public function addToResources(\App\Lib\Unifaun\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The resources property can only contain items of type \App\Lib\Unifaun\StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->resources[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Receipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
