<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for archive StructType
 * Meta informations extracted from the WSDL
 * - type: tns:archive
 * @subpackage Structs
 */
class Archive extends AbstractStructBase
{
    /**
     * The AuthenticationToken
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\AuthenticationToken
     */
    public $AuthenticationToken;
    /**
     * The consignmentNo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consignmentNo;
    /**
     * Constructor method for archive
     * @uses Archive::setAuthenticationToken()
     * @uses Archive::setConsignmentNo()
     * @param \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken
     * @param string $consignmentNo
     */
    public function __construct(\App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken = null, $consignmentNo = null)
    {
        $this
            ->setAuthenticationToken($authenticationToken)
            ->setConsignmentNo($consignmentNo);
    }
    /**
     * Get AuthenticationToken value
     * @return \App\Lib\Unifaun\StructType\AuthenticationToken|null
     */
    public function getAuthenticationToken()
    {
        return $this->AuthenticationToken;
    }
    /**
     * Set AuthenticationToken value
     * @param \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken
     * @return \App\Lib\Unifaun\StructType\Archive
     */
    public function setAuthenticationToken(\App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken = null)
    {
        $this->AuthenticationToken = $authenticationToken;
        return $this;
    }
    /**
     * Get consignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->consignmentNo;
    }
    /**
     * Set consignmentNo value
     * @param string $consignmentNo
     * @return \App\Lib\Unifaun\StructType\Archive
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNo, true), gettype($consignmentNo)), __LINE__);
        }
        $this->consignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Archive
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
