<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageIds StructType
 * @subpackage Structs
 */
class PackageIds extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:code
     * @var string[]
     */
    public $code;
    /**
     * Constructor method for PackageIds
     * @uses PackageIds::setCode()
     * @param string[] $code
     */
    public function __construct(array $code = array())
    {
        $this
            ->setCode($code);
    }
    /**
     * Get code value
     * @return string[]|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * This method is responsible for validating the values passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeForArrayConstraintsFromSetCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageIdsCodeItem) {
            // validation for constraint: itemType
            if (!is_string($packageIdsCodeItem)) {
                $invalidValues[] = is_object($packageIdsCodeItem) ? get_class($packageIdsCodeItem) : sprintf('%s(%s)', gettype($packageIdsCodeItem), var_export($packageIdsCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The code property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set code value
     * @throws \InvalidArgumentException
     * @param string[] $code
     * @return \App\Lib\Unifaun\StructType\PackageIds
     */
    public function setCode(array $code = array())
    {
        // validation for constraint: array
        if ('' !== ($codeArrayErrorMessage = self::validateCodeForArrayConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeArrayErrorMessage, __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Add item to code value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\PackageIds
     */
    public function addToCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The code property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->code[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\PackageIds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
