<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:id
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:name
     * @var string
     */
    public $name;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:address
     * @var string[]
     */
    public $address;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:postcode
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:city
     * @var string
     */
    public $city;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:state
     * @var string
     */
    public $state;
    /**
     * The countrycode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:countrycode
     * @var string
     */
    public $countrycode;
    /**
     * The posX
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:posX
     * @var float
     */
    public $posX;
    /**
     * The posY
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:posY
     * @var float
     */
    public $posY;
    /**
     * The posSystem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:posSystem
     * @var string
     */
    public $posSystem;
    /**
     * Constructor method for Address
     * @uses Address::setId()
     * @uses Address::setName()
     * @uses Address::setAddress()
     * @uses Address::setPostcode()
     * @uses Address::setCity()
     * @uses Address::setState()
     * @uses Address::setCountrycode()
     * @uses Address::setPosX()
     * @uses Address::setPosY()
     * @uses Address::setPosSystem()
     * @param string $id
     * @param string $name
     * @param string[] $address
     * @param string $postcode
     * @param string $city
     * @param string $state
     * @param string $countrycode
     * @param float $posX
     * @param float $posY
     * @param string $posSystem
     */
    public function __construct($id = null, $name = null, array $address = array(), $postcode = null, $city = null, $state = null, $countrycode = null, $posX = null, $posY = null, $posSystem = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setAddress($address)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setState($state)
            ->setCountrycode($countrycode)
            ->setPosX($posX)
            ->setPosY($posY)
            ->setPosSystem($posSystem);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get address value
     * @return string[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressAddressItem) {
            // validation for constraint: itemType
            if (!is_string($addressAddressItem)) {
                $invalidValues[] = is_object($addressAddressItem) ? get_class($addressAddressItem) : sprintf('%s(%s)', gettype($addressAddressItem), var_export($addressAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param string[] $address
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function addToAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get countrycode value
     * @return string|null
     */
    public function getCountrycode()
    {
        return $this->countrycode;
    }
    /**
     * Set countrycode value
     * @param string $countrycode
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setCountrycode($countrycode = null)
    {
        // validation for constraint: string
        if (!is_null($countrycode) && !is_string($countrycode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrycode, true), gettype($countrycode)), __LINE__);
        }
        $this->countrycode = $countrycode;
        return $this;
    }
    /**
     * Get posX value
     * @return float|null
     */
    public function getPosX()
    {
        return $this->posX;
    }
    /**
     * Set posX value
     * @param float $posX
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setPosX($posX = null)
    {
        // validation for constraint: float
        if (!is_null($posX) && !(is_float($posX) || is_numeric($posX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($posX, true), gettype($posX)), __LINE__);
        }
        $this->posX = $posX;
        return $this;
    }
    /**
     * Get posY value
     * @return float|null
     */
    public function getPosY()
    {
        return $this->posY;
    }
    /**
     * Set posY value
     * @param float $posY
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setPosY($posY = null)
    {
        // validation for constraint: float
        if (!is_null($posY) && !(is_float($posY) || is_numeric($posY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($posY, true), gettype($posY)), __LINE__);
        }
        $this->posY = $posY;
        return $this;
    }
    /**
     * Get posSystem value
     * @return string|null
     */
    public function getPosSystem()
    {
        return $this->posSystem;
    }
    /**
     * Set posSystem value
     * @param string $posSystem
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public function setPosSystem($posSystem = null)
    {
        // validation for constraint: string
        if (!is_null($posSystem) && !is_string($posSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posSystem, true), gettype($posSystem)), __LINE__);
        }
        $this->posSystem = $posSystem;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
