<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsignmentList StructType
 * @subpackage Structs
 */
class ConsignmentList extends AbstractStructBase
{
    /**
     * The Consignment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \App\Lib\Unifaun\StructType\Consignment[]
     */
    public $Consignment;
    /**
     * Constructor method for ConsignmentList
     * @uses ConsignmentList::setConsignment()
     * @param \App\Lib\Unifaun\StructType\Consignment[] $consignment
     */
    public function __construct(array $consignment = array())
    {
        $this
            ->setConsignment($consignment);
    }
    /**
     * Get Consignment value
     * @return \App\Lib\Unifaun\StructType\Consignment[]|null
     */
    public function getConsignment()
    {
        return $this->Consignment;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentForArrayConstraintsFromSetConsignment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentListConsignmentItem) {
            // validation for constraint: itemType
            if (!$consignmentListConsignmentItem instanceof \App\Lib\Unifaun\StructType\Consignment) {
                $invalidValues[] = is_object($consignmentListConsignmentItem) ? get_class($consignmentListConsignmentItem) : sprintf('%s(%s)', gettype($consignmentListConsignmentItem), var_export($consignmentListConsignmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Consignment property can only contain items of type \App\Lib\Unifaun\StructType\Consignment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Consignment value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Consignment[] $consignment
     * @return \App\Lib\Unifaun\StructType\ConsignmentList
     */
    public function setConsignment(array $consignment = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentArrayErrorMessage = self::validateConsignmentForArrayConstraintsFromSetConsignment($consignment))) {
            throw new \InvalidArgumentException($consignmentArrayErrorMessage, __LINE__);
        }
        $this->Consignment = $consignment;
        return $this;
    }
    /**
     * Add item to Consignment value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Consignment $item
     * @return \App\Lib\Unifaun\StructType\ConsignmentList
     */
    public function addToConsignment(\App\Lib\Unifaun\StructType\Consignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Consignment) {
            throw new \InvalidArgumentException(sprintf('The Consignment property can only contain items of type \App\Lib\Unifaun\StructType\Consignment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Consignment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\ConsignmentList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
