<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportProduct StructType
 * @subpackage Structs
 */
class TransportProduct extends AbstractStructBase
{
    /**
     * The mode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:mode
     * @var string
     */
    public $mode;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:code
     * @var string
     */
    public $code;
    /**
     * The PaymentInstruction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\PaymentInstruction
     */
    public $PaymentInstruction;
    /**
     * The AddService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\AddService[]
     */
    public $AddService;
    /**
     * The advice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:advice
     * @var bool
     */
    public $advice;
    /**
     * The Tod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Tod
     */
    public $Tod;
    /**
     * The Cod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Cod
     */
    public $Cod;
    /**
     * The Pickup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Pickup
     */
    public $Pickup;
    /**
     * The Delivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Delivery
     */
    public $Delivery;
    /**
     * The Transport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Transport
     */
    public $Transport;
    /**
     * The CustomsClearance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\CustomsClearance[]
     */
    public $CustomsClearance;
    /**
     * The Sortcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Sortcode
     */
    public $Sortcode;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Insurance
     */
    public $Insurance;
    /**
     * The ServiceOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\ServiceOption[]
     */
    public $ServiceOption;
    /**
     * Constructor method for TransportProduct
     * @uses TransportProduct::setMode()
     * @uses TransportProduct::setCode()
     * @uses TransportProduct::setPaymentInstruction()
     * @uses TransportProduct::setAddService()
     * @uses TransportProduct::setAdvice()
     * @uses TransportProduct::setTod()
     * @uses TransportProduct::setCod()
     * @uses TransportProduct::setPickup()
     * @uses TransportProduct::setDelivery()
     * @uses TransportProduct::setTransport()
     * @uses TransportProduct::setCustomsClearance()
     * @uses TransportProduct::setSortcode()
     * @uses TransportProduct::setInsurance()
     * @uses TransportProduct::setServiceOption()
     * @param string $mode
     * @param string $code
     * @param \App\Lib\Unifaun\StructType\PaymentInstruction $paymentInstruction
     * @param \App\Lib\Unifaun\StructType\AddService[] $addService
     * @param bool $advice
     * @param \App\Lib\Unifaun\StructType\Tod $tod
     * @param \App\Lib\Unifaun\StructType\Cod $cod
     * @param \App\Lib\Unifaun\StructType\Pickup $pickup
     * @param \App\Lib\Unifaun\StructType\Delivery $delivery
     * @param \App\Lib\Unifaun\StructType\Transport $transport
     * @param \App\Lib\Unifaun\StructType\CustomsClearance[] $customsClearance
     * @param \App\Lib\Unifaun\StructType\Sortcode $sortcode
     * @param \App\Lib\Unifaun\StructType\Insurance $insurance
     * @param \App\Lib\Unifaun\StructType\ServiceOption[] $serviceOption
     */
    public function __construct($mode = null, $code = null, \App\Lib\Unifaun\StructType\PaymentInstruction $paymentInstruction = null, array $addService = array(), $advice = null, \App\Lib\Unifaun\StructType\Tod $tod = null, \App\Lib\Unifaun\StructType\Cod $cod = null, \App\Lib\Unifaun\StructType\Pickup $pickup = null, \App\Lib\Unifaun\StructType\Delivery $delivery = null, \App\Lib\Unifaun\StructType\Transport $transport = null, array $customsClearance = array(), \App\Lib\Unifaun\StructType\Sortcode $sortcode = null, \App\Lib\Unifaun\StructType\Insurance $insurance = null, array $serviceOption = array())
    {
        $this
            ->setMode($mode)
            ->setCode($code)
            ->setPaymentInstruction($paymentInstruction)
            ->setAddService($addService)
            ->setAdvice($advice)
            ->setTod($tod)
            ->setCod($cod)
            ->setPickup($pickup)
            ->setDelivery($delivery)
            ->setTransport($transport)
            ->setCustomsClearance($customsClearance)
            ->setSortcode($sortcode)
            ->setInsurance($insurance)
            ->setServiceOption($serviceOption);
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @param string $mode
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mode, true), gettype($mode)), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get PaymentInstruction value
     * @return \App\Lib\Unifaun\StructType\PaymentInstruction|null
     */
    public function getPaymentInstruction()
    {
        return $this->PaymentInstruction;
    }
    /**
     * Set PaymentInstruction value
     * @param \App\Lib\Unifaun\StructType\PaymentInstruction $paymentInstruction
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setPaymentInstruction(\App\Lib\Unifaun\StructType\PaymentInstruction $paymentInstruction = null)
    {
        $this->PaymentInstruction = $paymentInstruction;
        return $this;
    }
    /**
     * Get AddService value
     * @return \App\Lib\Unifaun\StructType\AddService[]|null
     */
    public function getAddService()
    {
        return $this->AddService;
    }
    /**
     * This method is responsible for validating the values passed to the setAddService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddServiceForArrayConstraintsFromSetAddService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportProductAddServiceItem) {
            // validation for constraint: itemType
            if (!$transportProductAddServiceItem instanceof \App\Lib\Unifaun\StructType\AddService) {
                $invalidValues[] = is_object($transportProductAddServiceItem) ? get_class($transportProductAddServiceItem) : sprintf('%s(%s)', gettype($transportProductAddServiceItem), var_export($transportProductAddServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddService property can only contain items of type \App\Lib\Unifaun\StructType\AddService, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddService value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\AddService[] $addService
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setAddService(array $addService = array())
    {
        // validation for constraint: array
        if ('' !== ($addServiceArrayErrorMessage = self::validateAddServiceForArrayConstraintsFromSetAddService($addService))) {
            throw new \InvalidArgumentException($addServiceArrayErrorMessage, __LINE__);
        }
        $this->AddService = $addService;
        return $this;
    }
    /**
     * Add item to AddService value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\AddService $item
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function addToAddService(\App\Lib\Unifaun\StructType\AddService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\AddService) {
            throw new \InvalidArgumentException(sprintf('The AddService property can only contain items of type \App\Lib\Unifaun\StructType\AddService, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddService[] = $item;
        return $this;
    }
    /**
     * Get advice value
     * @return bool|null
     */
    public function getAdvice()
    {
        return $this->advice;
    }
    /**
     * Set advice value
     * @param bool $advice
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setAdvice($advice = null)
    {
        // validation for constraint: boolean
        if (!is_null($advice) && !is_bool($advice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advice, true), gettype($advice)), __LINE__);
        }
        $this->advice = $advice;
        return $this;
    }
    /**
     * Get Tod value
     * @return \App\Lib\Unifaun\StructType\Tod|null
     */
    public function getTod()
    {
        return $this->Tod;
    }
    /**
     * Set Tod value
     * @param \App\Lib\Unifaun\StructType\Tod $tod
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setTod(\App\Lib\Unifaun\StructType\Tod $tod = null)
    {
        $this->Tod = $tod;
        return $this;
    }
    /**
     * Get Cod value
     * @return \App\Lib\Unifaun\StructType\Cod|null
     */
    public function getCod()
    {
        return $this->Cod;
    }
    /**
     * Set Cod value
     * @param \App\Lib\Unifaun\StructType\Cod $cod
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setCod(\App\Lib\Unifaun\StructType\Cod $cod = null)
    {
        $this->Cod = $cod;
        return $this;
    }
    /**
     * Get Pickup value
     * @return \App\Lib\Unifaun\StructType\Pickup|null
     */
    public function getPickup()
    {
        return $this->Pickup;
    }
    /**
     * Set Pickup value
     * @param \App\Lib\Unifaun\StructType\Pickup $pickup
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setPickup(\App\Lib\Unifaun\StructType\Pickup $pickup = null)
    {
        $this->Pickup = $pickup;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \App\Lib\Unifaun\StructType\Delivery|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \App\Lib\Unifaun\StructType\Delivery $delivery
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setDelivery(\App\Lib\Unifaun\StructType\Delivery $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get Transport value
     * @return \App\Lib\Unifaun\StructType\Transport|null
     */
    public function getTransport()
    {
        return $this->Transport;
    }
    /**
     * Set Transport value
     * @param \App\Lib\Unifaun\StructType\Transport $transport
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setTransport(\App\Lib\Unifaun\StructType\Transport $transport = null)
    {
        $this->Transport = $transport;
        return $this;
    }
    /**
     * Get CustomsClearance value
     * @return \App\Lib\Unifaun\StructType\CustomsClearance[]|null
     */
    public function getCustomsClearance()
    {
        return $this->CustomsClearance;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomsClearance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsClearance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsClearanceForArrayConstraintsFromSetCustomsClearance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportProductCustomsClearanceItem) {
            // validation for constraint: itemType
            if (!$transportProductCustomsClearanceItem instanceof \App\Lib\Unifaun\StructType\CustomsClearance) {
                $invalidValues[] = is_object($transportProductCustomsClearanceItem) ? get_class($transportProductCustomsClearanceItem) : sprintf('%s(%s)', gettype($transportProductCustomsClearanceItem), var_export($transportProductCustomsClearanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomsClearance property can only contain items of type \App\Lib\Unifaun\StructType\CustomsClearance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomsClearance value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\CustomsClearance[] $customsClearance
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setCustomsClearance(array $customsClearance = array())
    {
        // validation for constraint: array
        if ('' !== ($customsClearanceArrayErrorMessage = self::validateCustomsClearanceForArrayConstraintsFromSetCustomsClearance($customsClearance))) {
            throw new \InvalidArgumentException($customsClearanceArrayErrorMessage, __LINE__);
        }
        $this->CustomsClearance = $customsClearance;
        return $this;
    }
    /**
     * Add item to CustomsClearance value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\CustomsClearance $item
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function addToCustomsClearance(\App\Lib\Unifaun\StructType\CustomsClearance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\CustomsClearance) {
            throw new \InvalidArgumentException(sprintf('The CustomsClearance property can only contain items of type \App\Lib\Unifaun\StructType\CustomsClearance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomsClearance[] = $item;
        return $this;
    }
    /**
     * Get Sortcode value
     * @return \App\Lib\Unifaun\StructType\Sortcode|null
     */
    public function getSortcode()
    {
        return $this->Sortcode;
    }
    /**
     * Set Sortcode value
     * @param \App\Lib\Unifaun\StructType\Sortcode $sortcode
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setSortcode(\App\Lib\Unifaun\StructType\Sortcode $sortcode = null)
    {
        $this->Sortcode = $sortcode;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \App\Lib\Unifaun\StructType\Insurance|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param \App\Lib\Unifaun\StructType\Insurance $insurance
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setInsurance(\App\Lib\Unifaun\StructType\Insurance $insurance = null)
    {
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get ServiceOption value
     * @return \App\Lib\Unifaun\StructType\ServiceOption[]|null
     */
    public function getServiceOption()
    {
        return $this->ServiceOption;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceOptionForArrayConstraintsFromSetServiceOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportProductServiceOptionItem) {
            // validation for constraint: itemType
            if (!$transportProductServiceOptionItem instanceof \App\Lib\Unifaun\StructType\ServiceOption) {
                $invalidValues[] = is_object($transportProductServiceOptionItem) ? get_class($transportProductServiceOptionItem) : sprintf('%s(%s)', gettype($transportProductServiceOptionItem), var_export($transportProductServiceOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceOption property can only contain items of type \App\Lib\Unifaun\StructType\ServiceOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceOption value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ServiceOption[] $serviceOption
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function setServiceOption(array $serviceOption = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceOptionArrayErrorMessage = self::validateServiceOptionForArrayConstraintsFromSetServiceOption($serviceOption))) {
            throw new \InvalidArgumentException($serviceOptionArrayErrorMessage, __LINE__);
        }
        $this->ServiceOption = $serviceOption;
        return $this;
    }
    /**
     * Add item to ServiceOption value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ServiceOption $item
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public function addToServiceOption(\App\Lib\Unifaun\StructType\ServiceOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ServiceOption) {
            throw new \InvalidArgumentException(sprintf('The ServiceOption property can only contain items of type \App\Lib\Unifaun\StructType\ServiceOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceOption[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\TransportProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
