<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsGroupItem StructType
 * @subpackage Structs
 */
class GoodsGroupItem extends AbstractStructBase
{
    /**
     * The ContentItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\ContentItem[]
     */
    public $ContentItem;
    /**
     * The GoodsItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\GoodsItem[]
     */
    public $GoodsItem;
    /**
     * Constructor method for GoodsGroupItem
     * @uses GoodsGroupItem::setContentItem()
     * @uses GoodsGroupItem::setGoodsItem()
     * @param \App\Lib\Unifaun\StructType\ContentItem[] $contentItem
     * @param \App\Lib\Unifaun\StructType\GoodsItem[] $goodsItem
     */
    public function __construct(array $contentItem = array(), array $goodsItem = array())
    {
        $this
            ->setContentItem($contentItem)
            ->setGoodsItem($goodsItem);
    }
    /**
     * Get ContentItem value
     * @return \App\Lib\Unifaun\StructType\ContentItem[]|null
     */
    public function getContentItem()
    {
        return $this->ContentItem;
    }
    /**
     * This method is responsible for validating the values passed to the setContentItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentItemForArrayConstraintsFromSetContentItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsGroupItemContentItemItem) {
            // validation for constraint: itemType
            if (!$goodsGroupItemContentItemItem instanceof \App\Lib\Unifaun\StructType\ContentItem) {
                $invalidValues[] = is_object($goodsGroupItemContentItemItem) ? get_class($goodsGroupItemContentItemItem) : sprintf('%s(%s)', gettype($goodsGroupItemContentItemItem), var_export($goodsGroupItemContentItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContentItem property can only contain items of type \App\Lib\Unifaun\StructType\ContentItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContentItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ContentItem[] $contentItem
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public function setContentItem(array $contentItem = array())
    {
        // validation for constraint: array
        if ('' !== ($contentItemArrayErrorMessage = self::validateContentItemForArrayConstraintsFromSetContentItem($contentItem))) {
            throw new \InvalidArgumentException($contentItemArrayErrorMessage, __LINE__);
        }
        $this->ContentItem = $contentItem;
        return $this;
    }
    /**
     * Add item to ContentItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ContentItem $item
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public function addToContentItem(\App\Lib\Unifaun\StructType\ContentItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ContentItem) {
            throw new \InvalidArgumentException(sprintf('The ContentItem property can only contain items of type \App\Lib\Unifaun\StructType\ContentItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContentItem[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \App\Lib\Unifaun\StructType\GoodsItem[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsGroupItemGoodsItemItem) {
            // validation for constraint: itemType
            if (!$goodsGroupItemGoodsItemItem instanceof \App\Lib\Unifaun\StructType\GoodsItem) {
                $invalidValues[] = is_object($goodsGroupItemGoodsItemItem) ? get_class($goodsGroupItemGoodsItemItem) : sprintf('%s(%s)', gettype($goodsGroupItemGoodsItemItem), var_export($goodsGroupItemGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \App\Lib\Unifaun\StructType\GoodsItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsItem[] $goodsItem
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsItem $item
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public function addToGoodsItem(\App\Lib\Unifaun\StructType\GoodsItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\GoodsItem) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \App\Lib\Unifaun\StructType\GoodsItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
