<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsGroup StructType
 * @subpackage Structs
 */
class GoodsGroup extends AbstractStructBase
{
    /**
     * The GoodsGroupItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\GoodsGroupItem[]
     */
    public $GoodsGroupItem;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $name;
    /**
     * Constructor method for GoodsGroup
     * @uses GoodsGroup::setGoodsGroupItem()
     * @uses GoodsGroup::setName()
     * @param \App\Lib\Unifaun\StructType\GoodsGroupItem[] $goodsGroupItem
     * @param string $name
     */
    public function __construct(array $goodsGroupItem = array(), $name = null)
    {
        $this
            ->setGoodsGroupItem($goodsGroupItem)
            ->setName($name);
    }
    /**
     * Get GoodsGroupItem value
     * @return \App\Lib\Unifaun\StructType\GoodsGroupItem[]|null
     */
    public function getGoodsGroupItem()
    {
        return $this->GoodsGroupItem;
    }
    /**
     * Set GoodsGroupItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsGroupItem[] $goodsGroupItem
     * @return \App\Lib\Unifaun\StructType\GoodsGroup
     */
    public function setGoodsGroupItem(array $goodsGroupItem = array())
    {
        foreach ($goodsGroupItem as $goodsGroupGoodsGroupItemItem) {
            // validation for constraint: itemType
            if (!$goodsGroupGoodsGroupItemItem instanceof \App\Lib\Unifaun\StructType\GoodsGroupItem) {
                throw new \InvalidArgumentException(sprintf('The GoodsGroupItem property can only contain items of \App\Lib\Unifaun\StructType\GoodsGroupItem, "%s" given', is_object($goodsGroupGoodsGroupItemItem) ? get_class($goodsGroupGoodsGroupItemItem) : gettype($goodsGroupGoodsGroupItemItem)), __LINE__);
            }
        }
        $this->GoodsGroupItem = $goodsGroupItem;
        return $this;
    }
    /**
     * Add item to GoodsGroupItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\GoodsGroupItem $item
     * @return \App\Lib\Unifaun\StructType\GoodsGroup
     */
    public function addToGoodsGroupItem(\App\Lib\Unifaun\StructType\GoodsGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\GoodsGroupItem) {
            throw new \InvalidArgumentException(sprintf('The GoodsGroupItem property can only contain items of \App\Lib\Unifaun\StructType\GoodsGroupItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GoodsGroupItem[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Lib\Unifaun\StructType\GoodsGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\GoodsGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
