<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Delivery StructType
 * @subpackage Structs
 */
class Delivery extends AbstractStructBase
{
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:date
     * @var string
     */
    public $date;
    /**
     * The earliest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:earliest
     * @var string
     */
    public $earliest;
    /**
     * The latest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:latest
     * @var string
     */
    public $latest;
    /**
     * The instruction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:instruction
     * @var string[]
     */
    public $instruction;
    /**
     * Constructor method for Delivery
     * @uses Delivery::setDate()
     * @uses Delivery::setEarliest()
     * @uses Delivery::setLatest()
     * @uses Delivery::setInstruction()
     * @param string $date
     * @param string $earliest
     * @param string $latest
     * @param string[] $instruction
     */
    public function __construct($date = null, $earliest = null, $latest = null, array $instruction = array())
    {
        $this
            ->setDate($date)
            ->setEarliest($earliest)
            ->setLatest($latest)
            ->setInstruction($instruction);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \App\Lib\Unifaun\StructType\Delivery
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get earliest value
     * @return string|null
     */
    public function getEarliest()
    {
        return $this->earliest;
    }
    /**
     * Set earliest value
     * @param string $earliest
     * @return \App\Lib\Unifaun\StructType\Delivery
     */
    public function setEarliest($earliest = null)
    {
        // validation for constraint: string
        if (!is_null($earliest) && !is_string($earliest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earliest)), __LINE__);
        }
        $this->earliest = $earliest;
        return $this;
    }
    /**
     * Get latest value
     * @return string|null
     */
    public function getLatest()
    {
        return $this->latest;
    }
    /**
     * Set latest value
     * @param string $latest
     * @return \App\Lib\Unifaun\StructType\Delivery
     */
    public function setLatest($latest = null)
    {
        // validation for constraint: string
        if (!is_null($latest) && !is_string($latest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latest)), __LINE__);
        }
        $this->latest = $latest;
        return $this;
    }
    /**
     * Get instruction value
     * @return string[]|null
     */
    public function getInstruction()
    {
        return $this->instruction;
    }
    /**
     * Set instruction value
     * @throws \InvalidArgumentException
     * @param string[] $instruction
     * @return \App\Lib\Unifaun\StructType\Delivery
     */
    public function setInstruction(array $instruction = array())
    {
        foreach ($instruction as $deliveryInstructionItem) {
            // validation for constraint: itemType
            if (!is_string($deliveryInstructionItem)) {
                throw new \InvalidArgumentException(sprintf('The instruction property can only contain items of string, "%s" given', is_object($deliveryInstructionItem) ? get_class($deliveryInstructionItem) : gettype($deliveryInstructionItem)), __LINE__);
            }
        }
        $this->instruction = $instruction;
        return $this;
    }
    /**
     * Add item to instruction value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\Delivery
     */
    public function addToInstruction($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The instruction property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->instruction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Delivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
