<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageIds StructType
 * @subpackage Structs
 */
class PackageIds extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:code
     * @var string[]
     */
    public $code;
    /**
     * Constructor method for PackageIds
     * @uses PackageIds::setCode()
     * @param string[] $code
     */
    public function __construct(array $code = array())
    {
        $this
            ->setCode($code);
    }
    /**
     * Get code value
     * @return string[]|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @throws \InvalidArgumentException
     * @param string[] $code
     * @return \App\Lib\Unifaun\StructType\PackageIds
     */
    public function setCode(array $code = array())
    {
        foreach ($code as $packageIdsCodeItem) {
            // validation for constraint: itemType
            if (!is_string($packageIdsCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The code property can only contain items of string, "%s" given', is_object($packageIdsCodeItem) ? get_class($packageIdsCodeItem) : gettype($packageIdsCodeItem)), __LINE__);
            }
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Add item to code value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\PackageIds
     */
    public function addToCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The code property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->code[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\PackageIds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
