<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelResult StructType
 * @subpackage Structs
 */
class CancelResult extends AbstractStructBase
{
    /**
     * The consignmentNo
     * @var string
     */
    public $consignmentNo;
    /**
     * The errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Error[]
     */
    public $errors;
    /**
     * The statusCode
     * @var int
     */
    public $statusCode;
    /**
     * Constructor method for cancelResult
     * @uses CancelResult::setConsignmentNo()
     * @uses CancelResult::setErrors()
     * @uses CancelResult::setStatusCode()
     * @param string $consignmentNo
     * @param \App\Lib\Unifaun\StructType\Error[] $errors
     * @param int $statusCode
     */
    public function __construct($consignmentNo = null, array $errors = array(), $statusCode = null)
    {
        $this
            ->setConsignmentNo($consignmentNo)
            ->setErrors($errors)
            ->setStatusCode($statusCode);
    }
    /**
     * Get consignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->consignmentNo;
    }
    /**
     * Set consignmentNo value
     * @param string $consignmentNo
     * @return \App\Lib\Unifaun\StructType\CancelResult
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentNo)), __LINE__);
        }
        $this->consignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Error[]|null
     */
    public function getErrors()
    {
        return isset($this->errors) ? $this->errors : null;
    }
    /**
     * Set errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Error[] $errors
     * @return \App\Lib\Unifaun\StructType\CancelResult
     */
    public function setErrors(array $errors = array())
    {
        foreach ($errors as $cancelResultErrorsItem) {
            // validation for constraint: itemType
            if (!$cancelResultErrorsItem instanceof \App\Lib\Unifaun\StructType\Error) {
                throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \App\Lib\Unifaun\StructType\Error, "%s" given', is_object($cancelResultErrorsItem) ? get_class($cancelResultErrorsItem) : gettype($cancelResultErrorsItem)), __LINE__);
            }
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->errors);
        } else {
            $this->errors = $errors;
        }
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Error $item
     * @return \App\Lib\Unifaun\StructType\CancelResult
     */
    public function addToErrors(\App\Lib\Unifaun\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \App\Lib\Unifaun\StructType\Error, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Get statusCode value
     * @return int|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param int $statusCode
     * @return \App\Lib\Unifaun\StructType\CancelResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !is_numeric($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\CancelResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
