<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transport StructType
 * @subpackage Structs
 */
class Transport extends AbstractStructBase
{
    /**
     * The instruction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:instruction
     * @var string[]
     */
    public $instruction;
    /**
     * The cooling
     * Meta informations extracted from the WSDL
     * - ref: tns:cooling
     * @var bool
     */
    public $cooling;
    /**
     * The heating
     * Meta informations extracted from the WSDL
     * - ref: tns:heating
     * @var bool
     */
    public $heating;
    /**
     * The frozen
     * Meta informations extracted from the WSDL
     * - ref: tns:frozen
     * @var bool
     */
    public $frozen;
    /**
     * The tempLow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:tempLow
     * @var int
     */
    public $tempLow;
    /**
     * The tempHigh
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:tempHigh
     * @var int
     */
    public $tempHigh;
    /**
     * The subsidyNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:subsidyNo
     * @var string
     */
    public $subsidyNo;
    /**
     * The valuableGoods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:valuableGoods
     * @var bool
     */
    public $valuableGoods;
    /**
     * The carryIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:carryIn
     * @var bool
     */
    public $carryIn;
    /**
     * The extraCrew
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:extraCrew
     * @var bool
     */
    public $extraCrew;
    /**
     * The eurPallets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:eurPallets
     * @var int
     */
    public $eurPallets;
    /**
     * The limitedQuantityDangerousGoods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:limitedQuantityDangerousGoods
     * @var bool
     */
    public $limitedQuantityDangerousGoods;
    /**
     * Constructor method for Transport
     * @uses Transport::setInstruction()
     * @uses Transport::setCooling()
     * @uses Transport::setHeating()
     * @uses Transport::setFrozen()
     * @uses Transport::setTempLow()
     * @uses Transport::setTempHigh()
     * @uses Transport::setSubsidyNo()
     * @uses Transport::setValuableGoods()
     * @uses Transport::setCarryIn()
     * @uses Transport::setExtraCrew()
     * @uses Transport::setEurPallets()
     * @uses Transport::setLimitedQuantityDangerousGoods()
     * @param string[] $instruction
     * @param bool $cooling
     * @param bool $heating
     * @param bool $frozen
     * @param int $tempLow
     * @param int $tempHigh
     * @param string $subsidyNo
     * @param bool $valuableGoods
     * @param bool $carryIn
     * @param bool $extraCrew
     * @param int $eurPallets
     * @param bool $limitedQuantityDangerousGoods
     */
    public function __construct(array $instruction = array(), $cooling = null, $heating = null, $frozen = null, $tempLow = null, $tempHigh = null, $subsidyNo = null, $valuableGoods = null, $carryIn = null, $extraCrew = null, $eurPallets = null, $limitedQuantityDangerousGoods = null)
    {
        $this
            ->setInstruction($instruction)
            ->setCooling($cooling)
            ->setHeating($heating)
            ->setFrozen($frozen)
            ->setTempLow($tempLow)
            ->setTempHigh($tempHigh)
            ->setSubsidyNo($subsidyNo)
            ->setValuableGoods($valuableGoods)
            ->setCarryIn($carryIn)
            ->setExtraCrew($extraCrew)
            ->setEurPallets($eurPallets)
            ->setLimitedQuantityDangerousGoods($limitedQuantityDangerousGoods);
    }
    /**
     * Get instruction value
     * @return string[]|null
     */
    public function getInstruction()
    {
        return $this->instruction;
    }
    /**
     * Set instruction value
     * @throws \InvalidArgumentException
     * @param string[] $instruction
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setInstruction(array $instruction = array())
    {
        foreach ($instruction as $transportInstructionItem) {
            // validation for constraint: itemType
            if (!is_string($transportInstructionItem)) {
                throw new \InvalidArgumentException(sprintf('The instruction property can only contain items of string, "%s" given', is_object($transportInstructionItem) ? get_class($transportInstructionItem) : gettype($transportInstructionItem)), __LINE__);
            }
        }
        $this->instruction = $instruction;
        return $this;
    }
    /**
     * Add item to instruction value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function addToInstruction($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The instruction property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->instruction[] = $item;
        return $this;
    }
    /**
     * Get cooling value
     * @return bool|null
     */
    public function getCooling()
    {
        return $this->cooling;
    }
    /**
     * Set cooling value
     * @param bool $cooling
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setCooling($cooling = null)
    {
        // validation for constraint: boolean
        if (!is_null($cooling) && !is_bool($cooling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cooling)), __LINE__);
        }
        $this->cooling = $cooling;
        return $this;
    }
    /**
     * Get heating value
     * @return bool|null
     */
    public function getHeating()
    {
        return $this->heating;
    }
    /**
     * Set heating value
     * @param bool $heating
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setHeating($heating = null)
    {
        // validation for constraint: boolean
        if (!is_null($heating) && !is_bool($heating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($heating)), __LINE__);
        }
        $this->heating = $heating;
        return $this;
    }
    /**
     * Get frozen value
     * @return bool|null
     */
    public function getFrozen()
    {
        return $this->frozen;
    }
    /**
     * Set frozen value
     * @param bool $frozen
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setFrozen($frozen = null)
    {
        // validation for constraint: boolean
        if (!is_null($frozen) && !is_bool($frozen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($frozen)), __LINE__);
        }
        $this->frozen = $frozen;
        return $this;
    }
    /**
     * Get tempLow value
     * @return int|null
     */
    public function getTempLow()
    {
        return $this->tempLow;
    }
    /**
     * Set tempLow value
     * @param int $tempLow
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setTempLow($tempLow = null)
    {
        // validation for constraint: int
        if (!is_null($tempLow) && !is_numeric($tempLow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tempLow)), __LINE__);
        }
        $this->tempLow = $tempLow;
        return $this;
    }
    /**
     * Get tempHigh value
     * @return int|null
     */
    public function getTempHigh()
    {
        return $this->tempHigh;
    }
    /**
     * Set tempHigh value
     * @param int $tempHigh
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setTempHigh($tempHigh = null)
    {
        // validation for constraint: int
        if (!is_null($tempHigh) && !is_numeric($tempHigh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tempHigh)), __LINE__);
        }
        $this->tempHigh = $tempHigh;
        return $this;
    }
    /**
     * Get subsidyNo value
     * @return string|null
     */
    public function getSubsidyNo()
    {
        return $this->subsidyNo;
    }
    /**
     * Set subsidyNo value
     * @param string $subsidyNo
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setSubsidyNo($subsidyNo = null)
    {
        // validation for constraint: string
        if (!is_null($subsidyNo) && !is_string($subsidyNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subsidyNo)), __LINE__);
        }
        $this->subsidyNo = $subsidyNo;
        return $this;
    }
    /**
     * Get valuableGoods value
     * @return bool|null
     */
    public function getValuableGoods()
    {
        return $this->valuableGoods;
    }
    /**
     * Set valuableGoods value
     * @param bool $valuableGoods
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setValuableGoods($valuableGoods = null)
    {
        // validation for constraint: boolean
        if (!is_null($valuableGoods) && !is_bool($valuableGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($valuableGoods)), __LINE__);
        }
        $this->valuableGoods = $valuableGoods;
        return $this;
    }
    /**
     * Get carryIn value
     * @return bool|null
     */
    public function getCarryIn()
    {
        return $this->carryIn;
    }
    /**
     * Set carryIn value
     * @param bool $carryIn
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setCarryIn($carryIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($carryIn) && !is_bool($carryIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($carryIn)), __LINE__);
        }
        $this->carryIn = $carryIn;
        return $this;
    }
    /**
     * Get extraCrew value
     * @return bool|null
     */
    public function getExtraCrew()
    {
        return $this->extraCrew;
    }
    /**
     * Set extraCrew value
     * @param bool $extraCrew
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setExtraCrew($extraCrew = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraCrew) && !is_bool($extraCrew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extraCrew)), __LINE__);
        }
        $this->extraCrew = $extraCrew;
        return $this;
    }
    /**
     * Get eurPallets value
     * @return int|null
     */
    public function getEurPallets()
    {
        return $this->eurPallets;
    }
    /**
     * Set eurPallets value
     * @param int $eurPallets
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setEurPallets($eurPallets = null)
    {
        // validation for constraint: int
        if (!is_null($eurPallets) && !is_numeric($eurPallets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eurPallets)), __LINE__);
        }
        $this->eurPallets = $eurPallets;
        return $this;
    }
    /**
     * Get limitedQuantityDangerousGoods value
     * @return bool|null
     */
    public function getLimitedQuantityDangerousGoods()
    {
        return $this->limitedQuantityDangerousGoods;
    }
    /**
     * Set limitedQuantityDangerousGoods value
     * @param bool $limitedQuantityDangerousGoods
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public function setLimitedQuantityDangerousGoods($limitedQuantityDangerousGoods = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitedQuantityDangerousGoods) && !is_bool($limitedQuantityDangerousGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($limitedQuantityDangerousGoods)), __LINE__);
        }
        $this->limitedQuantityDangerousGoods = $limitedQuantityDangerousGoods;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Transport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
