<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculatedPrice StructType
 * @subpackage Structs
 */
class CalculatedPrice extends AbstractStructBase
{
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currency;
    /**
     * The priceDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\PriceDetail[]
     */
    public $priceDetail;
    /**
     * Constructor method for CalculatedPrice
     * @uses CalculatedPrice::setPrice()
     * @uses CalculatedPrice::setCurrency()
     * @uses CalculatedPrice::setPriceDetail()
     * @param float $price
     * @param string $currency
     * @param \App\Lib\Unifaun\StructType\PriceDetail[] $priceDetail
     */
    public function __construct($price = null, $currency = null, array $priceDetail = array())
    {
        $this
            ->setPrice($price)
            ->setCurrency($currency)
            ->setPriceDetail($priceDetail);
    }
    /**
     * Get price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice()
    {
        return isset($this->price) ? $this->price : null;
    }
    /**
     * Set price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public function setPrice($price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->price);
        } else {
            $this->price = $price;
        }
        return $this;
    }
    /**
     * Get currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->currency) ? $this->currency : null;
    }
    /**
     * Set currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->currency);
        } else {
            $this->currency = $currency;
        }
        return $this;
    }
    /**
     * Get priceDetail value
     * @return \App\Lib\Unifaun\StructType\PriceDetail[]|null
     */
    public function getPriceDetail()
    {
        return $this->priceDetail;
    }
    /**
     * Set priceDetail value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\PriceDetail[] $priceDetail
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public function setPriceDetail(array $priceDetail = array())
    {
        foreach ($priceDetail as $calculatedPricePriceDetailItem) {
            // validation for constraint: itemType
            if (!$calculatedPricePriceDetailItem instanceof \App\Lib\Unifaun\StructType\PriceDetail) {
                throw new \InvalidArgumentException(sprintf('The priceDetail property can only contain items of \App\Lib\Unifaun\StructType\PriceDetail, "%s" given', is_object($calculatedPricePriceDetailItem) ? get_class($calculatedPricePriceDetailItem) : gettype($calculatedPricePriceDetailItem)), __LINE__);
            }
        }
        $this->priceDetail = $priceDetail;
        return $this;
    }
    /**
     * Add item to priceDetail value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\PriceDetail $item
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public function addToPriceDetail(\App\Lib\Unifaun\StructType\PriceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\PriceDetail) {
            throw new \InvalidArgumentException(sprintf('The priceDetail property can only contain items of \App\Lib\Unifaun\StructType\PriceDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->priceDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
