<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItemResult StructType
 * @subpackage Structs
 */
class GoodsItemResult extends AbstractStructBase
{
    /**
     * The consignmentMergeKey
     * @var string
     */
    public $consignmentMergeKey;
    /**
     * The consignmentNo
     * @var string
     */
    public $consignmentNo;
    /**
     * The addedPackageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $addedPackageId;
    /**
     * The deletedPackageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deletedPackageId;
    /**
     * The errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\Error[]
     */
    public $errors;
    /**
     * Constructor method for GoodsItemResult
     * @uses GoodsItemResult::setConsignmentMergeKey()
     * @uses GoodsItemResult::setConsignmentNo()
     * @uses GoodsItemResult::setAddedPackageId()
     * @uses GoodsItemResult::setDeletedPackageId()
     * @uses GoodsItemResult::setErrors()
     * @param string $consignmentMergeKey
     * @param string $consignmentNo
     * @param string $addedPackageId
     * @param string $deletedPackageId
     * @param \App\Lib\Unifaun\StructType\Error[] $errors
     */
    public function __construct($consignmentMergeKey = null, $consignmentNo = null, $addedPackageId = null, $deletedPackageId = null, array $errors = array())
    {
        $this
            ->setConsignmentMergeKey($consignmentMergeKey)
            ->setConsignmentNo($consignmentNo)
            ->setAddedPackageId($addedPackageId)
            ->setDeletedPackageId($deletedPackageId)
            ->setErrors($errors);
    }
    /**
     * Get consignmentMergeKey value
     * @return string|null
     */
    public function getConsignmentMergeKey()
    {
        return $this->consignmentMergeKey;
    }
    /**
     * Set consignmentMergeKey value
     * @param string $consignmentMergeKey
     * @return \App\Lib\Unifaun\StructType\GoodsItemResult
     */
    public function setConsignmentMergeKey($consignmentMergeKey = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentMergeKey) && !is_string($consignmentMergeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentMergeKey)), __LINE__);
        }
        $this->consignmentMergeKey = $consignmentMergeKey;
        return $this;
    }
    /**
     * Get consignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->consignmentNo;
    }
    /**
     * Set consignmentNo value
     * @param string $consignmentNo
     * @return \App\Lib\Unifaun\StructType\GoodsItemResult
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentNo)), __LINE__);
        }
        $this->consignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get addedPackageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddedPackageId()
    {
        return isset($this->addedPackageId) ? $this->addedPackageId : null;
    }
    /**
     * Set addedPackageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addedPackageId
     * @return \App\Lib\Unifaun\StructType\GoodsItemResult
     */
    public function setAddedPackageId($addedPackageId = null)
    {
        // validation for constraint: string
        if (!is_null($addedPackageId) && !is_string($addedPackageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addedPackageId)), __LINE__);
        }
        if (is_null($addedPackageId) || (is_array($addedPackageId) && empty($addedPackageId))) {
            unset($this->addedPackageId);
        } else {
            $this->addedPackageId = $addedPackageId;
        }
        return $this;
    }
    /**
     * Get deletedPackageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeletedPackageId()
    {
        return isset($this->deletedPackageId) ? $this->deletedPackageId : null;
    }
    /**
     * Set deletedPackageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deletedPackageId
     * @return \App\Lib\Unifaun\StructType\GoodsItemResult
     */
    public function setDeletedPackageId($deletedPackageId = null)
    {
        // validation for constraint: string
        if (!is_null($deletedPackageId) && !is_string($deletedPackageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deletedPackageId)), __LINE__);
        }
        if (is_null($deletedPackageId) || (is_array($deletedPackageId) && empty($deletedPackageId))) {
            unset($this->deletedPackageId);
        } else {
            $this->deletedPackageId = $deletedPackageId;
        }
        return $this;
    }
    /**
     * Get errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Lib\Unifaun\StructType\Error[]|null
     */
    public function getErrors()
    {
        return isset($this->errors) ? $this->errors : null;
    }
    /**
     * Set errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Error[] $errors
     * @return \App\Lib\Unifaun\StructType\GoodsItemResult
     */
    public function setErrors(array $errors = array())
    {
        foreach ($errors as $goodsItemResultErrorsItem) {
            // validation for constraint: itemType
            if (!$goodsItemResultErrorsItem instanceof \App\Lib\Unifaun\StructType\Error) {
                throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \App\Lib\Unifaun\StructType\Error, "%s" given', is_object($goodsItemResultErrorsItem) ? get_class($goodsItemResultErrorsItem) : gettype($goodsItemResultErrorsItem)), __LINE__);
            }
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->errors);
        } else {
            $this->errors = $errors;
        }
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Error $item
     * @return \App\Lib\Unifaun\StructType\GoodsItemResult
     */
    public function addToErrors(\App\Lib\Unifaun\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of \App\Lib\Unifaun\StructType\Error, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\GoodsItemResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
