<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOption StructType
 * @subpackage Structs
 */
class ServiceOption extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The ServiceOptionItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\ServiceOptionItem[]
     */
    public $ServiceOptionItem;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $value;
    /**
     * Constructor method for ServiceOption
     * @uses ServiceOption::setType()
     * @uses ServiceOption::setServiceOptionItem()
     * @uses ServiceOption::setValue()
     * @param string $type
     * @param \App\Lib\Unifaun\StructType\ServiceOptionItem[] $serviceOptionItem
     * @param string $value
     */
    public function __construct($type = null, array $serviceOptionItem = array(), $value = null)
    {
        $this
            ->setType($type)
            ->setServiceOptionItem($serviceOptionItem)
            ->setValue($value);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get ServiceOptionItem value
     * @return \App\Lib\Unifaun\StructType\ServiceOptionItem[]|null
     */
    public function getServiceOptionItem()
    {
        return $this->ServiceOptionItem;
    }
    /**
     * Set ServiceOptionItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ServiceOptionItem[] $serviceOptionItem
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public function setServiceOptionItem(array $serviceOptionItem = array())
    {
        foreach ($serviceOptionItem as $serviceOptionServiceOptionItemItem) {
            // validation for constraint: itemType
            if (!$serviceOptionServiceOptionItemItem instanceof \App\Lib\Unifaun\StructType\ServiceOptionItem) {
                throw new \InvalidArgumentException(sprintf('The ServiceOptionItem property can only contain items of \App\Lib\Unifaun\StructType\ServiceOptionItem, "%s" given', is_object($serviceOptionServiceOptionItemItem) ? get_class($serviceOptionServiceOptionItemItem) : gettype($serviceOptionServiceOptionItemItem)), __LINE__);
            }
        }
        $this->ServiceOptionItem = $serviceOptionItem;
        return $this;
    }
    /**
     * Add item to ServiceOptionItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ServiceOptionItem $item
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public function addToServiceOptionItem(\App\Lib\Unifaun\StructType\ServiceOptionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ServiceOptionItem) {
            throw new \InvalidArgumentException(sprintf('The ServiceOptionItem property can only contain items of \App\Lib\Unifaun\StructType\ServiceOptionItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceOptionItem[] = $item;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\ServiceOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
