<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printLabel StructType
 * Meta informations extracted from the WSDL
 * - type: tns:printLabel
 * @subpackage Structs
 */
class PrintLabel extends AbstractStructBase
{
    /**
     * The arrayOfPackageIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $arrayOfPackageIds;
    /**
     * The AuthenticationToken
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \App\Lib\Unifaun\StructType\AuthenticationToken
     */
    public $AuthenticationToken;
    /**
     * The consignmentNo
     * @var string
     */
    public $consignmentNo;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $format;
    /**
     * Constructor method for printLabel
     * @uses PrintLabel::setArrayOfPackageIds()
     * @uses PrintLabel::setAuthenticationToken()
     * @uses PrintLabel::setConsignmentNo()
     * @uses PrintLabel::setFormat()
     * @param string[] $arrayOfPackageIds
     * @param \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken
     * @param string $consignmentNo
     * @param string $format
     */
    public function __construct(array $arrayOfPackageIds = array(), \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken = null, $consignmentNo = null, $format = null)
    {
        $this
            ->setArrayOfPackageIds($arrayOfPackageIds)
            ->setAuthenticationToken($authenticationToken)
            ->setConsignmentNo($consignmentNo)
            ->setFormat($format);
    }
    /**
     * Get arrayOfPackageIds value
     * @return string[]
     */
    public function getArrayOfPackageIds()
    {
        return $this->arrayOfPackageIds;
    }
    /**
     * Set arrayOfPackageIds value
     * @throws \InvalidArgumentException
     * @param string[] $arrayOfPackageIds
     * @return \App\Lib\Unifaun\StructType\PrintLabel
     */
    public function setArrayOfPackageIds(array $arrayOfPackageIds = array())
    {
        foreach ($arrayOfPackageIds as $printLabelArrayOfPackageIdsItem) {
            // validation for constraint: itemType
            if (!is_string($printLabelArrayOfPackageIdsItem)) {
                throw new \InvalidArgumentException(sprintf('The arrayOfPackageIds property can only contain items of string, "%s" given', is_object($printLabelArrayOfPackageIdsItem) ? get_class($printLabelArrayOfPackageIdsItem) : gettype($printLabelArrayOfPackageIdsItem)), __LINE__);
            }
        }
        $this->arrayOfPackageIds = $arrayOfPackageIds;
        return $this;
    }
    /**
     * Add item to arrayOfPackageIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\PrintLabel
     */
    public function addToArrayOfPackageIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The arrayOfPackageIds property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->arrayOfPackageIds[] = $item;
        return $this;
    }
    /**
     * Get AuthenticationToken value
     * @return \App\Lib\Unifaun\StructType\AuthenticationToken|null
     */
    public function getAuthenticationToken()
    {
        return $this->AuthenticationToken;
    }
    /**
     * Set AuthenticationToken value
     * @param \App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken
     * @return \App\Lib\Unifaun\StructType\PrintLabel
     */
    public function setAuthenticationToken(\App\Lib\Unifaun\StructType\AuthenticationToken $authenticationToken = null)
    {
        $this->AuthenticationToken = $authenticationToken;
        return $this;
    }
    /**
     * Get consignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->consignmentNo;
    }
    /**
     * Set consignmentNo value
     * @param string $consignmentNo
     * @return \App\Lib\Unifaun\StructType\PrintLabel
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentNo)), __LINE__);
        }
        $this->consignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \App\Lib\Unifaun\StructType\PrintLabel
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\PrintLabel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
