<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contents StructType
 * @subpackage Structs
 */
class Contents extends AbstractStructBase
{
    /**
     * The ContentItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \App\Lib\Unifaun\StructType\ContentItem[]
     */
    public $ContentItem;
    /**
     * Constructor method for Contents
     * @uses Contents::setContentItem()
     * @param \App\Lib\Unifaun\StructType\ContentItem[] $contentItem
     */
    public function __construct(array $contentItem = array())
    {
        $this
            ->setContentItem($contentItem);
    }
    /**
     * Get ContentItem value
     * @return \App\Lib\Unifaun\StructType\ContentItem[]|null
     */
    public function getContentItem()
    {
        return $this->ContentItem;
    }
    /**
     * Set ContentItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ContentItem[] $contentItem
     * @return \App\Lib\Unifaun\StructType\Contents
     */
    public function setContentItem(array $contentItem = array())
    {
        foreach ($contentItem as $contentsContentItemItem) {
            // validation for constraint: itemType
            if (!$contentsContentItemItem instanceof \App\Lib\Unifaun\StructType\ContentItem) {
                throw new \InvalidArgumentException(sprintf('The ContentItem property can only contain items of \App\Lib\Unifaun\StructType\ContentItem, "%s" given', is_object($contentsContentItemItem) ? get_class($contentsContentItemItem) : gettype($contentsContentItemItem)), __LINE__);
            }
        }
        $this->ContentItem = $contentItem;
        return $this;
    }
    /**
     * Add item to ContentItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ContentItem $item
     * @return \App\Lib\Unifaun\StructType\Contents
     */
    public function addToContentItem(\App\Lib\Unifaun\StructType\ContentItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ContentItem) {
            throw new \InvalidArgumentException(sprintf('The ContentItem property can only contain items of \App\Lib\Unifaun\StructType\ContentItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContentItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Contents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
