<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentItem StructType
 * Meta informations extracted from the WSDL
 * - maxOccurs: 1
 * - minOccurs: 0
 * - ref: tns:warehouseId
 * @subpackage Structs
 */
class ContentItem extends AbstractStructBase
{
    /**
     * The noOfOrderedItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:noOfOrderedItems
     * @var string
     */
    public $noOfOrderedItems;
    /**
     * The noOfDeliveredItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:noOfDeliveredItems
     * @var string
     */
    public $noOfDeliveredItems;
    /**
     * The articleNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:articleNo
     * @var string
     */
    public $articleNo;
    /**
     * The productName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:productName
     * @var string
     */
    public $productName;
    /**
     * The productAttribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:productAttribute
     * @var string[]
     */
    public $productAttribute;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:weight
     * @var float
     */
    public $weight;
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:volume
     * @var float
     */
    public $volume;
    /**
     * The length
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:length
     * @var float
     */
    public $length;
    /**
     * The width
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:width
     * @var float
     */
    public $width;
    /**
     * The height
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:height
     * @var float
     */
    public $height;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:price
     * @var float
     */
    public $price;
    /**
     * The packageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:packageType
     * @var string
     */
    public $packageType;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:location
     * @var string
     */
    public $location;
    /**
     * The notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:notes
     * @var string
     */
    public $notes;
    /**
     * The itemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:itemId
     * @var string
     */
    public $itemId;
    /**
     * The statisticalNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:statisticalNo
     * @var string
     */
    public $statisticalNo;
    /**
     * Constructor method for ContentItem
     * @uses ContentItem::setNoOfOrderedItems()
     * @uses ContentItem::setNoOfDeliveredItems()
     * @uses ContentItem::setArticleNo()
     * @uses ContentItem::setProductName()
     * @uses ContentItem::setProductAttribute()
     * @uses ContentItem::setWeight()
     * @uses ContentItem::setVolume()
     * @uses ContentItem::setLength()
     * @uses ContentItem::setWidth()
     * @uses ContentItem::setHeight()
     * @uses ContentItem::setPrice()
     * @uses ContentItem::setPackageType()
     * @uses ContentItem::setLocation()
     * @uses ContentItem::setNotes()
     * @uses ContentItem::setItemId()
     * @uses ContentItem::setStatisticalNo()
     * @param string $noOfOrderedItems
     * @param string $noOfDeliveredItems
     * @param string $articleNo
     * @param string $productName
     * @param string[] $productAttribute
     * @param float $weight
     * @param float $volume
     * @param float $length
     * @param float $width
     * @param float $height
     * @param float $price
     * @param string $packageType
     * @param string $location
     * @param string $notes
     * @param string $itemId
     * @param string $statisticalNo
     */
    public function __construct($noOfOrderedItems = null, $noOfDeliveredItems = null, $articleNo = null, $productName = null, array $productAttribute = array(), $weight = null, $volume = null, $length = null, $width = null, $height = null, $price = null, $packageType = null, $location = null, $notes = null, $itemId = null, $statisticalNo = null)
    {
        $this
            ->setNoOfOrderedItems($noOfOrderedItems)
            ->setNoOfDeliveredItems($noOfDeliveredItems)
            ->setArticleNo($articleNo)
            ->setProductName($productName)
            ->setProductAttribute($productAttribute)
            ->setWeight($weight)
            ->setVolume($volume)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setPrice($price)
            ->setPackageType($packageType)
            ->setLocation($location)
            ->setNotes($notes)
            ->setItemId($itemId)
            ->setStatisticalNo($statisticalNo);
    }
    /**
     * Get noOfOrderedItems value
     * @return string|null
     */
    public function getNoOfOrderedItems()
    {
        return $this->noOfOrderedItems;
    }
    /**
     * Set noOfOrderedItems value
     * @param string $noOfOrderedItems
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setNoOfOrderedItems($noOfOrderedItems = null)
    {
        // validation for constraint: string
        if (!is_null($noOfOrderedItems) && !is_string($noOfOrderedItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noOfOrderedItems)), __LINE__);
        }
        $this->noOfOrderedItems = $noOfOrderedItems;
        return $this;
    }
    /**
     * Get noOfDeliveredItems value
     * @return string|null
     */
    public function getNoOfDeliveredItems()
    {
        return $this->noOfDeliveredItems;
    }
    /**
     * Set noOfDeliveredItems value
     * @param string $noOfDeliveredItems
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setNoOfDeliveredItems($noOfDeliveredItems = null)
    {
        // validation for constraint: string
        if (!is_null($noOfDeliveredItems) && !is_string($noOfDeliveredItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noOfDeliveredItems)), __LINE__);
        }
        $this->noOfDeliveredItems = $noOfDeliveredItems;
        return $this;
    }
    /**
     * Get articleNo value
     * @return string|null
     */
    public function getArticleNo()
    {
        return $this->articleNo;
    }
    /**
     * Set articleNo value
     * @param string $articleNo
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setArticleNo($articleNo = null)
    {
        // validation for constraint: string
        if (!is_null($articleNo) && !is_string($articleNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($articleNo)), __LINE__);
        }
        $this->articleNo = $articleNo;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get productAttribute value
     * @return string[]|null
     */
    public function getProductAttribute()
    {
        return $this->productAttribute;
    }
    /**
     * Set productAttribute value
     * @throws \InvalidArgumentException
     * @param string[] $productAttribute
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setProductAttribute(array $productAttribute = array())
    {
        foreach ($productAttribute as $contentItemProductAttributeItem) {
            // validation for constraint: itemType
            if (!is_string($contentItemProductAttributeItem)) {
                throw new \InvalidArgumentException(sprintf('The productAttribute property can only contain items of string, "%s" given', is_object($contentItemProductAttributeItem) ? get_class($contentItemProductAttributeItem) : gettype($contentItemProductAttributeItem)), __LINE__);
            }
        }
        $this->productAttribute = $productAttribute;
        return $this;
    }
    /**
     * Add item to productAttribute value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function addToProductAttribute($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The productAttribute property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->productAttribute[] = $item;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setWeight($weight = null)
    {
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setVolume($volume = null)
    {
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setLength($length = null)
    {
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setWidth($width = null)
    {
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setHeight($height = null)
    {
        $this->height = $height;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get packageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->packageType;
    }
    /**
     * Set packageType value
     * @param string $packageType
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageType)), __LINE__);
        }
        $this->packageType = $packageType;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get statisticalNo value
     * @return string|null
     */
    public function getStatisticalNo()
    {
        return $this->statisticalNo;
    }
    /**
     * Set statisticalNo value
     * @param string $statisticalNo
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public function setStatisticalNo($statisticalNo = null)
    {
        // validation for constraint: string
        if (!is_null($statisticalNo) && !is_string($statisticalNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statisticalNo)), __LINE__);
        }
        $this->statisticalNo = $statisticalNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\ContentItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
