<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cod StructType
 * @subpackage Structs
 */
class Cod extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - ref: tns:amount
     * @var float
     */
    public $amount;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - ref: tns:currency
     * @var string
     */
    public $currency;
    /**
     * The paymentMethod
     * Meta informations extracted from the WSDL
     * - ref: tns:paymentMethod
     * @var string
     */
    public $paymentMethod;
    /**
     * The accountNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:accountNo
     * @var string
     */
    public $accountNo;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:reference
     * @var string
     */
    public $reference;
    /**
     * The referenceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:referenceType
     * @var string
     */
    public $referenceType;
    /**
     * Constructor method for Cod
     * @uses Cod::setAmount()
     * @uses Cod::setCurrency()
     * @uses Cod::setPaymentMethod()
     * @uses Cod::setAccountNo()
     * @uses Cod::setReference()
     * @uses Cod::setReferenceType()
     * @param float $amount
     * @param string $currency
     * @param string $paymentMethod
     * @param string $accountNo
     * @param string $reference
     * @param string $referenceType
     */
    public function __construct($amount = null, $currency = null, $paymentMethod = null, $accountNo = null, $reference = null, $referenceType = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setPaymentMethod($paymentMethod)
            ->setAccountNo($accountNo)
            ->setReference($reference)
            ->setReferenceType($referenceType);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \App\Lib\Unifaun\StructType\Cod
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \App\Lib\Unifaun\StructType\Cod
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \App\Lib\Unifaun\StructType\Cod
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get accountNo value
     * @return string|null
     */
    public function getAccountNo()
    {
        return $this->accountNo;
    }
    /**
     * Set accountNo value
     * @param string $accountNo
     * @return \App\Lib\Unifaun\StructType\Cod
     */
    public function setAccountNo($accountNo = null)
    {
        // validation for constraint: string
        if (!is_null($accountNo) && !is_string($accountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNo)), __LINE__);
        }
        $this->accountNo = $accountNo;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \App\Lib\Unifaun\StructType\Cod
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get referenceType value
     * @return string|null
     */
    public function getReferenceType()
    {
        return $this->referenceType;
    }
    /**
     * Set referenceType value
     * @param string $referenceType
     * @return \App\Lib\Unifaun\StructType\Cod
     */
    public function setReferenceType($referenceType = null)
    {
        // validation for constraint: string
        if (!is_null($referenceType) && !is_string($referenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceType)), __LINE__);
        }
        $this->referenceType = $referenceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Cod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
