<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Part StructType
 * @subpackage Structs
 */
class Part extends AbstractStructBase
{
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $role;
    /**
     * The Address
     * @var \App\Lib\Unifaun\StructType\Address
     */
    public $Address;
    /**
     * The Communication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Communication
     */
    public $Communication;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\Reference
     */
    public $Reference;
    /**
     * The account
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $account;
    /**
     * Constructor method for Part
     * @uses Part::setRole()
     * @uses Part::setAddress()
     * @uses Part::setCommunication()
     * @uses Part::setReference()
     * @uses Part::setAccount()
     * @param string $role
     * @param \App\Lib\Unifaun\StructType\Address $address
     * @param \App\Lib\Unifaun\StructType\Communication $communication
     * @param \App\Lib\Unifaun\StructType\Reference $reference
     * @param string $account
     */
    public function __construct($role = null, \App\Lib\Unifaun\StructType\Address $address = null, \App\Lib\Unifaun\StructType\Communication $communication = null, \App\Lib\Unifaun\StructType\Reference $reference = null, $account = null)
    {
        $this
            ->setRole($role)
            ->setAddress($address)
            ->setCommunication($communication)
            ->setReference($reference)
            ->setAccount($account);
    }
    /**
     * Get role value
     * @return string
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \App\Lib\Unifaun\StructType\Part
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get Address value
     * @return \App\Lib\Unifaun\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \App\Lib\Unifaun\StructType\Address $address
     * @return \App\Lib\Unifaun\StructType\Part
     */
    public function setAddress(\App\Lib\Unifaun\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Communication value
     * @return \App\Lib\Unifaun\StructType\Communication|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * Set Communication value
     * @param \App\Lib\Unifaun\StructType\Communication $communication
     * @return \App\Lib\Unifaun\StructType\Part
     */
    public function setCommunication(\App\Lib\Unifaun\StructType\Communication $communication = null)
    {
        $this->Communication = $communication;
        return $this;
    }
    /**
     * Get Reference value
     * @return \App\Lib\Unifaun\StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \App\Lib\Unifaun\StructType\Reference $reference
     * @return \App\Lib\Unifaun\StructType\Part
     */
    public function setReference(\App\Lib\Unifaun\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param string $account
     * @return \App\Lib\Unifaun\StructType\Part
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($account)), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\Part
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
