<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsignmentList StructType
 * @subpackage Structs
 */
class ConsignmentList extends AbstractStructBase
{
    /**
     * The Consignment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \App\Lib\Unifaun\StructType\Consignment[]
     */
    public $Consignment;
    /**
     * Constructor method for ConsignmentList
     * @uses ConsignmentList::setConsignment()
     * @param \App\Lib\Unifaun\StructType\Consignment[] $consignment
     */
    public function __construct(array $consignment = array())
    {
        $this
            ->setConsignment($consignment);
    }
    /**
     * Get Consignment value
     * @return \App\Lib\Unifaun\StructType\Consignment[]|null
     */
    public function getConsignment()
    {
        return $this->Consignment;
    }
    /**
     * Set Consignment value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Consignment[] $consignment
     * @return \App\Lib\Unifaun\StructType\ConsignmentList
     */
    public function setConsignment(array $consignment = array())
    {
        foreach ($consignment as $consignmentListConsignmentItem) {
            // validation for constraint: itemType
            if (!$consignmentListConsignmentItem instanceof \App\Lib\Unifaun\StructType\Consignment) {
                throw new \InvalidArgumentException(sprintf('The Consignment property can only contain items of \App\Lib\Unifaun\StructType\Consignment, "%s" given', is_object($consignmentListConsignmentItem) ? get_class($consignmentListConsignmentItem) : gettype($consignmentListConsignmentItem)), __LINE__);
            }
        }
        $this->Consignment = $consignment;
        return $this;
    }
    /**
     * Add item to Consignment value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\Consignment $item
     * @return \App\Lib\Unifaun\StructType\ConsignmentList
     */
    public function addToConsignment(\App\Lib\Unifaun\StructType\Consignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\Consignment) {
            throw new \InvalidArgumentException(sprintf('The Consignment property can only contain items of \App\Lib\Unifaun\StructType\Consignment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Consignment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\ConsignmentList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
