<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://saglikt.sgk.gov.tr/medula/eczane/saglikTesisiYardimciIslemleriWS?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://saglikt.sgk.gov.tr/medula/eczane/saglikTesisiYardimciIslemleriWS?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Aktif ServiceType
 */
$aktif = new \ServiceType\Aktif($options);
/**
 * Sample call for aktifIlacListesiSorgula operation/method
 */
if ($aktif->aktifIlacListesiSorgula(new \StructType\AktifIlacListesiSorgula()) !== false) {
    print_r($aktif->getResult());
} else {
    print_r($aktif->getLastError());
}
/**
 * Sample call for aktifYurtdisiIlacListesiSorgula operation/method
 */
if ($aktif->aktifYurtdisiIlacListesiSorgula(new \StructType\AktifYurtdisiIlacListesiSorgula()) !== false) {
    print_r($aktif->getResult());
} else {
    print_r($aktif->getLastError());
}
/**
 * Samples for Pasif ServiceType
 */
$pasif = new \ServiceType\Pasif($options);
/**
 * Sample call for pasifIlacListesiSorgula operation/method
 */
if ($pasif->pasifIlacListesiSorgula(new \StructType\PasifIlacListesiSorgula()) !== false) {
    print_r($pasif->getResult());
} else {
    print_r($pasif->getLastError());
}
/**
 * Sample call for pasifYurtdisiIlacListesiSorgula operation/method
 */
if ($pasif->pasifYurtdisiIlacListesiSorgula(new \StructType\PasifYurtdisiIlacListesiSorgula()) !== false) {
    print_r($pasif->getResult());
} else {
    print_r($pasif->getLastError());
}
/**
 * Samples for Normal ServiceType
 */
$normal = new \ServiceType\Normal($options);
/**
 * Sample call for normalReceteIlacListesiSorgula operation/method
 */
if ($normal->normalReceteIlacListesiSorgula(new \StructType\NormalReceteIlacListesiSorgula()) !== false) {
    print_r($normal->getResult());
} else {
    print_r($normal->getLastError());
}
/**
 * Sample call for normalReceteYurtdisiIlacListesiSorgula operation/method
 */
if ($normal->normalReceteYurtdisiIlacListesiSorgula(new \StructType\NormalReceteYurtdisiIlacListesiSorgula()) !== false) {
    print_r($normal->getResult());
} else {
    print_r($normal->getLastError());
}
/**
 * Samples for Kirmizi ServiceType
 */
$kirmizi = new \ServiceType\Kirmizi($options);
/**
 * Sample call for kirmiziReceteIlacListesiSorgula operation/method
 */
if ($kirmizi->kirmiziReceteIlacListesiSorgula(new \StructType\KirmiziReceteIlacListesiSorgula()) !== false) {
    print_r($kirmizi->getResult());
} else {
    print_r($kirmizi->getLastError());
}
/**
 * Sample call for kirmiziReceteYurtdisiIlacListesiSorgula operation/method
 */
if ($kirmizi->kirmiziReceteYurtdisiIlacListesiSorgula(new \StructType\KirmiziReceteYurtdisiIlacListesiSorgula()) !== false) {
    print_r($kirmizi->getResult());
} else {
    print_r($kirmizi->getLastError());
}
/**
 * Samples for Turuncu ServiceType
 */
$turuncu = new \ServiceType\Turuncu($options);
/**
 * Sample call for turuncuReceteIlacListesiSorgula operation/method
 */
if ($turuncu->turuncuReceteIlacListesiSorgula(new \StructType\TuruncuReceteIlacListesiSorgula()) !== false) {
    print_r($turuncu->getResult());
} else {
    print_r($turuncu->getLastError());
}
/**
 * Sample call for turuncuReceteYurtdisiIlacListesiSorgula operation/method
 */
if ($turuncu->turuncuReceteYurtdisiIlacListesiSorgula(new \StructType\TuruncuReceteYurtdisiIlacListesiSorgula()) !== false) {
    print_r($turuncu->getResult());
} else {
    print_r($turuncu->getLastError());
}
/**
 * Samples for Mor ServiceType
 */
$mor = new \ServiceType\Mor($options);
/**
 * Sample call for morReceteIlacListesiSorgula operation/method
 */
if ($mor->morReceteIlacListesiSorgula(new \StructType\MorReceteIlacListesiSorgula()) !== false) {
    print_r($mor->getResult());
} else {
    print_r($mor->getLastError());
}
/**
 * Sample call for morReceteYurtdisiIlacListesiSorgula operation/method
 */
if ($mor->morReceteYurtdisiIlacListesiSorgula(new \StructType\MorReceteYurtdisiIlacListesiSorgula()) !== false) {
    print_r($mor->getResult());
} else {
    print_r($mor->getLastError());
}
/**
 * Samples for Yesil ServiceType
 */
$yesil = new \ServiceType\Yesil($options);
/**
 * Sample call for yesilReceteIlacListesiSorgula operation/method
 */
if ($yesil->yesilReceteIlacListesiSorgula(new \StructType\YesilReceteIlacListesiSorgula()) !== false) {
    print_r($yesil->getResult());
} else {
    print_r($yesil->getLastError());
}
/**
 * Sample call for yesilReceteYurtdisiIlacListesiSorgula operation/method
 */
if ($yesil->yesilReceteYurtdisiIlacListesiSorgula(new \StructType\YesilReceteYurtdisiIlacListesiSorgula()) !== false) {
    print_r($yesil->getResult());
} else {
    print_r($yesil->getLastError());
}
/**
 * Samples for Rapor ServiceType
 */
$rapor = new \ServiceType\Rapor($options);
/**
 * Sample call for raporTeshisListesiSorgula operation/method
 */
if ($rapor->raporTeshisListesiSorgula(new \StructType\RaporTeshisListesiSorgula()) !== false) {
    print_r($rapor->getResult());
} else {
    print_r($rapor->getLastError());
}
/**
 * Samples for Etkin ServiceType
 */
$etkin = new \ServiceType\Etkin($options);
/**
 * Sample call for etkinMaddeSutListesiSorgula operation/method
 */
if ($etkin->etkinMaddeSutListesiSorgula(new \StructType\EtkinMaddeSutListesiSorgula()) !== false) {
    print_r($etkin->getResult());
} else {
    print_r($etkin->getLastError());
}
/**
 * Sample call for etkinMaddeListesiSorgula operation/method
 */
if ($etkin->etkinMaddeListesiSorgula(new \StructType\EtkinMaddeListesiSorgula()) !== false) {
    print_r($etkin->getResult());
} else {
    print_r($etkin->getLastError());
}
/**
 * Samples for Yurtdisi ServiceType
 */
$yurtdisi = new \ServiceType\Yurtdisi($options);
/**
 * Sample call for yurtdisiIlacEtkinMaddeListesiSorgula operation/method
 */
if ($yurtdisi->yurtdisiIlacEtkinMaddeListesiSorgula(new \StructType\YurtdisiIlacEtkinMaddeListesiSorgula()) !== false) {
    print_r($yurtdisi->getResult());
} else {
    print_r($yurtdisi->getLastError());
}
