<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ilacListesiSorguCevapDVO StructType
 * @subpackage Structs
 */
class IlacListesiSorguCevapDVO extends AbstractStructBase
{
    /**
     * The ilacListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IlacDVO[]
     */
    public $ilacListesi;
    /**
     * The sonucKodu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sonucKodu;
    /**
     * The sonucMesaji
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sonucMesaji;
    /**
     * The uyariMesaji
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $uyariMesaji;
    /**
     * Constructor method for ilacListesiSorguCevapDVO
     * @uses IlacListesiSorguCevapDVO::setIlacListesi()
     * @uses IlacListesiSorguCevapDVO::setSonucKodu()
     * @uses IlacListesiSorguCevapDVO::setSonucMesaji()
     * @uses IlacListesiSorguCevapDVO::setUyariMesaji()
     * @param \StructType\IlacDVO[] $ilacListesi
     * @param string $sonucKodu
     * @param string $sonucMesaji
     * @param string $uyariMesaji
     */
    public function __construct(array $ilacListesi = array(), $sonucKodu = null, $sonucMesaji = null, $uyariMesaji = null)
    {
        $this
            ->setIlacListesi($ilacListesi)
            ->setSonucKodu($sonucKodu)
            ->setSonucMesaji($sonucMesaji)
            ->setUyariMesaji($uyariMesaji);
    }
    /**
     * Get ilacListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IlacDVO[]|null
     */
    public function getIlacListesi()
    {
        return isset($this->ilacListesi) ? $this->ilacListesi : null;
    }
    /**
     * Set ilacListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IlacDVO[] $ilacListesi
     * @return \StructType\IlacListesiSorguCevapDVO
     */
    public function setIlacListesi(array $ilacListesi = array())
    {
        foreach ($ilacListesi as $ilacListesiSorguCevapDVOIlacListesiItem) {
            // validation for constraint: itemType
            if (!$ilacListesiSorguCevapDVOIlacListesiItem instanceof \StructType\IlacDVO) {
                throw new \InvalidArgumentException(sprintf('The ilacListesi property can only contain items of \StructType\IlacDVO, "%s" given', is_object($ilacListesiSorguCevapDVOIlacListesiItem) ? get_class($ilacListesiSorguCevapDVOIlacListesiItem) : gettype($ilacListesiSorguCevapDVOIlacListesiItem)), __LINE__);
            }
        }
        if (is_null($ilacListesi) || (is_array($ilacListesi) && empty($ilacListesi))) {
            unset($this->ilacListesi);
        } else {
            $this->ilacListesi = $ilacListesi;
        }
        return $this;
    }
    /**
     * Add item to ilacListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\IlacDVO $item
     * @return \StructType\IlacListesiSorguCevapDVO
     */
    public function addToIlacListesi(\StructType\IlacDVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IlacDVO) {
            throw new \InvalidArgumentException(sprintf('The ilacListesi property can only contain items of \StructType\IlacDVO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ilacListesi[] = $item;
        return $this;
    }
    /**
     * Get sonucKodu value
     * @return string|null
     */
    public function getSonucKodu()
    {
        return $this->sonucKodu;
    }
    /**
     * Set sonucKodu value
     * @param string $sonucKodu
     * @return \StructType\IlacListesiSorguCevapDVO
     */
    public function setSonucKodu($sonucKodu = null)
    {
        // validation for constraint: string
        if (!is_null($sonucKodu) && !is_string($sonucKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sonucKodu)), __LINE__);
        }
        $this->sonucKodu = $sonucKodu;
        return $this;
    }
    /**
     * Get sonucMesaji value
     * @return string|null
     */
    public function getSonucMesaji()
    {
        return $this->sonucMesaji;
    }
    /**
     * Set sonucMesaji value
     * @param string $sonucMesaji
     * @return \StructType\IlacListesiSorguCevapDVO
     */
    public function setSonucMesaji($sonucMesaji = null)
    {
        // validation for constraint: string
        if (!is_null($sonucMesaji) && !is_string($sonucMesaji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sonucMesaji)), __LINE__);
        }
        $this->sonucMesaji = $sonucMesaji;
        return $this;
    }
    /**
     * Get uyariMesaji value
     * @return string|null
     */
    public function getUyariMesaji()
    {
        return $this->uyariMesaji;
    }
    /**
     * Set uyariMesaji value
     * @param string $uyariMesaji
     * @return \StructType\IlacListesiSorguCevapDVO
     */
    public function setUyariMesaji($uyariMesaji = null)
    {
        // validation for constraint: string
        if (!is_null($uyariMesaji) && !is_string($uyariMesaji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uyariMesaji)), __LINE__);
        }
        $this->uyariMesaji = $uyariMesaji;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IlacListesiSorguCevapDVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
