<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for etkinMaddeSutDVO StructType
 * @subpackage Structs
 */
class EtkinMaddeSutDVO extends AbstractStructBase
{
    /**
     * The etkinMaddeSutNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $etkinMaddeSutNo;
    /**
     * The raporTeshisListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RaporTeshisDVO[]
     */
    public $raporTeshisListesi;
    /**
     * The doktorBransListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $doktorBransListesi;
    /**
     * The doktorSertifikaListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $doktorSertifikaListesi;
    /**
     * The tesisAnaGrupListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $tesisAnaGrupListesi;
    /**
     * The raporDuzenlemeTuru
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $raporDuzenlemeTuru;
    /**
     * The cinsiyeti
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cinsiyeti;
    /**
     * The maksimumRaporTarihi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $maksimumRaporTarihi;
    /**
     * The minimumYasi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $minimumYasi;
    /**
     * The maksimumYasi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $maksimumYasi;
    /**
     * The maksimumRaporSuresi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $maksimumRaporSuresi;
    /**
     * The maksimumRaporSuresiBirimi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $maksimumRaporSuresiBirimi;
    /**
     * Constructor method for etkinMaddeSutDVO
     * @uses EtkinMaddeSutDVO::setEtkinMaddeSutNo()
     * @uses EtkinMaddeSutDVO::setRaporTeshisListesi()
     * @uses EtkinMaddeSutDVO::setDoktorBransListesi()
     * @uses EtkinMaddeSutDVO::setDoktorSertifikaListesi()
     * @uses EtkinMaddeSutDVO::setTesisAnaGrupListesi()
     * @uses EtkinMaddeSutDVO::setRaporDuzenlemeTuru()
     * @uses EtkinMaddeSutDVO::setCinsiyeti()
     * @uses EtkinMaddeSutDVO::setMaksimumRaporTarihi()
     * @uses EtkinMaddeSutDVO::setMinimumYasi()
     * @uses EtkinMaddeSutDVO::setMaksimumYasi()
     * @uses EtkinMaddeSutDVO::setMaksimumRaporSuresi()
     * @uses EtkinMaddeSutDVO::setMaksimumRaporSuresiBirimi()
     * @param string $etkinMaddeSutNo
     * @param \StructType\RaporTeshisDVO[] $raporTeshisListesi
     * @param string[] $doktorBransListesi
     * @param string[] $doktorSertifikaListesi
     * @param string[] $tesisAnaGrupListesi
     * @param string $raporDuzenlemeTuru
     * @param string $cinsiyeti
     * @param string $maksimumRaporTarihi
     * @param string $minimumYasi
     * @param string $maksimumYasi
     * @param string $maksimumRaporSuresi
     * @param string $maksimumRaporSuresiBirimi
     */
    public function __construct($etkinMaddeSutNo = null, array $raporTeshisListesi = array(), array $doktorBransListesi = array(), array $doktorSertifikaListesi = array(), array $tesisAnaGrupListesi = array(), $raporDuzenlemeTuru = null, $cinsiyeti = null, $maksimumRaporTarihi = null, $minimumYasi = null, $maksimumYasi = null, $maksimumRaporSuresi = null, $maksimumRaporSuresiBirimi = null)
    {
        $this
            ->setEtkinMaddeSutNo($etkinMaddeSutNo)
            ->setRaporTeshisListesi($raporTeshisListesi)
            ->setDoktorBransListesi($doktorBransListesi)
            ->setDoktorSertifikaListesi($doktorSertifikaListesi)
            ->setTesisAnaGrupListesi($tesisAnaGrupListesi)
            ->setRaporDuzenlemeTuru($raporDuzenlemeTuru)
            ->setCinsiyeti($cinsiyeti)
            ->setMaksimumRaporTarihi($maksimumRaporTarihi)
            ->setMinimumYasi($minimumYasi)
            ->setMaksimumYasi($maksimumYasi)
            ->setMaksimumRaporSuresi($maksimumRaporSuresi)
            ->setMaksimumRaporSuresiBirimi($maksimumRaporSuresiBirimi);
    }
    /**
     * Get etkinMaddeSutNo value
     * @return string|null
     */
    public function getEtkinMaddeSutNo()
    {
        return $this->etkinMaddeSutNo;
    }
    /**
     * Set etkinMaddeSutNo value
     * @param string $etkinMaddeSutNo
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setEtkinMaddeSutNo($etkinMaddeSutNo = null)
    {
        // validation for constraint: string
        if (!is_null($etkinMaddeSutNo) && !is_string($etkinMaddeSutNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($etkinMaddeSutNo)), __LINE__);
        }
        $this->etkinMaddeSutNo = $etkinMaddeSutNo;
        return $this;
    }
    /**
     * Get raporTeshisListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RaporTeshisDVO[]|null
     */
    public function getRaporTeshisListesi()
    {
        return isset($this->raporTeshisListesi) ? $this->raporTeshisListesi : null;
    }
    /**
     * Set raporTeshisListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RaporTeshisDVO[] $raporTeshisListesi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setRaporTeshisListesi(array $raporTeshisListesi = array())
    {
        foreach ($raporTeshisListesi as $etkinMaddeSutDVORaporTeshisListesiItem) {
            // validation for constraint: itemType
            if (!$etkinMaddeSutDVORaporTeshisListesiItem instanceof \StructType\RaporTeshisDVO) {
                throw new \InvalidArgumentException(sprintf('The raporTeshisListesi property can only contain items of \StructType\RaporTeshisDVO, "%s" given', is_object($etkinMaddeSutDVORaporTeshisListesiItem) ? get_class($etkinMaddeSutDVORaporTeshisListesiItem) : gettype($etkinMaddeSutDVORaporTeshisListesiItem)), __LINE__);
            }
        }
        if (is_null($raporTeshisListesi) || (is_array($raporTeshisListesi) && empty($raporTeshisListesi))) {
            unset($this->raporTeshisListesi);
        } else {
            $this->raporTeshisListesi = $raporTeshisListesi;
        }
        return $this;
    }
    /**
     * Add item to raporTeshisListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\RaporTeshisDVO $item
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function addToRaporTeshisListesi(\StructType\RaporTeshisDVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RaporTeshisDVO) {
            throw new \InvalidArgumentException(sprintf('The raporTeshisListesi property can only contain items of \StructType\RaporTeshisDVO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->raporTeshisListesi[] = $item;
        return $this;
    }
    /**
     * Get doktorBransListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDoktorBransListesi()
    {
        return isset($this->doktorBransListesi) ? $this->doktorBransListesi : null;
    }
    /**
     * Set doktorBransListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $doktorBransListesi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setDoktorBransListesi(array $doktorBransListesi = array())
    {
        foreach ($doktorBransListesi as $etkinMaddeSutDVODoktorBransListesiItem) {
            // validation for constraint: itemType
            if (!is_string($etkinMaddeSutDVODoktorBransListesiItem)) {
                throw new \InvalidArgumentException(sprintf('The doktorBransListesi property can only contain items of string, "%s" given', is_object($etkinMaddeSutDVODoktorBransListesiItem) ? get_class($etkinMaddeSutDVODoktorBransListesiItem) : gettype($etkinMaddeSutDVODoktorBransListesiItem)), __LINE__);
            }
        }
        if (is_null($doktorBransListesi) || (is_array($doktorBransListesi) && empty($doktorBransListesi))) {
            unset($this->doktorBransListesi);
        } else {
            $this->doktorBransListesi = $doktorBransListesi;
        }
        return $this;
    }
    /**
     * Add item to doktorBransListesi value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function addToDoktorBransListesi($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The doktorBransListesi property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->doktorBransListesi[] = $item;
        return $this;
    }
    /**
     * Get doktorSertifikaListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDoktorSertifikaListesi()
    {
        return isset($this->doktorSertifikaListesi) ? $this->doktorSertifikaListesi : null;
    }
    /**
     * Set doktorSertifikaListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $doktorSertifikaListesi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setDoktorSertifikaListesi(array $doktorSertifikaListesi = array())
    {
        foreach ($doktorSertifikaListesi as $etkinMaddeSutDVODoktorSertifikaListesiItem) {
            // validation for constraint: itemType
            if (!is_string($etkinMaddeSutDVODoktorSertifikaListesiItem)) {
                throw new \InvalidArgumentException(sprintf('The doktorSertifikaListesi property can only contain items of string, "%s" given', is_object($etkinMaddeSutDVODoktorSertifikaListesiItem) ? get_class($etkinMaddeSutDVODoktorSertifikaListesiItem) : gettype($etkinMaddeSutDVODoktorSertifikaListesiItem)), __LINE__);
            }
        }
        if (is_null($doktorSertifikaListesi) || (is_array($doktorSertifikaListesi) && empty($doktorSertifikaListesi))) {
            unset($this->doktorSertifikaListesi);
        } else {
            $this->doktorSertifikaListesi = $doktorSertifikaListesi;
        }
        return $this;
    }
    /**
     * Add item to doktorSertifikaListesi value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function addToDoktorSertifikaListesi($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The doktorSertifikaListesi property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->doktorSertifikaListesi[] = $item;
        return $this;
    }
    /**
     * Get tesisAnaGrupListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getTesisAnaGrupListesi()
    {
        return isset($this->tesisAnaGrupListesi) ? $this->tesisAnaGrupListesi : null;
    }
    /**
     * Set tesisAnaGrupListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $tesisAnaGrupListesi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setTesisAnaGrupListesi(array $tesisAnaGrupListesi = array())
    {
        foreach ($tesisAnaGrupListesi as $etkinMaddeSutDVOTesisAnaGrupListesiItem) {
            // validation for constraint: itemType
            if (!is_string($etkinMaddeSutDVOTesisAnaGrupListesiItem)) {
                throw new \InvalidArgumentException(sprintf('The tesisAnaGrupListesi property can only contain items of string, "%s" given', is_object($etkinMaddeSutDVOTesisAnaGrupListesiItem) ? get_class($etkinMaddeSutDVOTesisAnaGrupListesiItem) : gettype($etkinMaddeSutDVOTesisAnaGrupListesiItem)), __LINE__);
            }
        }
        if (is_null($tesisAnaGrupListesi) || (is_array($tesisAnaGrupListesi) && empty($tesisAnaGrupListesi))) {
            unset($this->tesisAnaGrupListesi);
        } else {
            $this->tesisAnaGrupListesi = $tesisAnaGrupListesi;
        }
        return $this;
    }
    /**
     * Add item to tesisAnaGrupListesi value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function addToTesisAnaGrupListesi($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The tesisAnaGrupListesi property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tesisAnaGrupListesi[] = $item;
        return $this;
    }
    /**
     * Get raporDuzenlemeTuru value
     * @return string|null
     */
    public function getRaporDuzenlemeTuru()
    {
        return $this->raporDuzenlemeTuru;
    }
    /**
     * Set raporDuzenlemeTuru value
     * @param string $raporDuzenlemeTuru
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setRaporDuzenlemeTuru($raporDuzenlemeTuru = null)
    {
        // validation for constraint: string
        if (!is_null($raporDuzenlemeTuru) && !is_string($raporDuzenlemeTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($raporDuzenlemeTuru)), __LINE__);
        }
        $this->raporDuzenlemeTuru = $raporDuzenlemeTuru;
        return $this;
    }
    /**
     * Get cinsiyeti value
     * @return string|null
     */
    public function getCinsiyeti()
    {
        return $this->cinsiyeti;
    }
    /**
     * Set cinsiyeti value
     * @param string $cinsiyeti
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setCinsiyeti($cinsiyeti = null)
    {
        // validation for constraint: string
        if (!is_null($cinsiyeti) && !is_string($cinsiyeti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cinsiyeti)), __LINE__);
        }
        $this->cinsiyeti = $cinsiyeti;
        return $this;
    }
    /**
     * Get maksimumRaporTarihi value
     * @return string|null
     */
    public function getMaksimumRaporTarihi()
    {
        return $this->maksimumRaporTarihi;
    }
    /**
     * Set maksimumRaporTarihi value
     * @param string $maksimumRaporTarihi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setMaksimumRaporTarihi($maksimumRaporTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($maksimumRaporTarihi) && !is_string($maksimumRaporTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maksimumRaporTarihi)), __LINE__);
        }
        $this->maksimumRaporTarihi = $maksimumRaporTarihi;
        return $this;
    }
    /**
     * Get minimumYasi value
     * @return string|null
     */
    public function getMinimumYasi()
    {
        return $this->minimumYasi;
    }
    /**
     * Set minimumYasi value
     * @param string $minimumYasi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setMinimumYasi($minimumYasi = null)
    {
        // validation for constraint: string
        if (!is_null($minimumYasi) && !is_string($minimumYasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumYasi)), __LINE__);
        }
        $this->minimumYasi = $minimumYasi;
        return $this;
    }
    /**
     * Get maksimumYasi value
     * @return string|null
     */
    public function getMaksimumYasi()
    {
        return $this->maksimumYasi;
    }
    /**
     * Set maksimumYasi value
     * @param string $maksimumYasi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setMaksimumYasi($maksimumYasi = null)
    {
        // validation for constraint: string
        if (!is_null($maksimumYasi) && !is_string($maksimumYasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maksimumYasi)), __LINE__);
        }
        $this->maksimumYasi = $maksimumYasi;
        return $this;
    }
    /**
     * Get maksimumRaporSuresi value
     * @return string|null
     */
    public function getMaksimumRaporSuresi()
    {
        return $this->maksimumRaporSuresi;
    }
    /**
     * Set maksimumRaporSuresi value
     * @param string $maksimumRaporSuresi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setMaksimumRaporSuresi($maksimumRaporSuresi = null)
    {
        // validation for constraint: string
        if (!is_null($maksimumRaporSuresi) && !is_string($maksimumRaporSuresi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maksimumRaporSuresi)), __LINE__);
        }
        $this->maksimumRaporSuresi = $maksimumRaporSuresi;
        return $this;
    }
    /**
     * Get maksimumRaporSuresiBirimi value
     * @return string|null
     */
    public function getMaksimumRaporSuresiBirimi()
    {
        return $this->maksimumRaporSuresiBirimi;
    }
    /**
     * Set maksimumRaporSuresiBirimi value
     * @param string $maksimumRaporSuresiBirimi
     * @return \StructType\EtkinMaddeSutDVO
     */
    public function setMaksimumRaporSuresiBirimi($maksimumRaporSuresiBirimi = null)
    {
        // validation for constraint: string
        if (!is_null($maksimumRaporSuresiBirimi) && !is_string($maksimumRaporSuresiBirimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maksimumRaporSuresiBirimi)), __LINE__);
        }
        $this->maksimumRaporSuresiBirimi = $maksimumRaporSuresiBirimi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EtkinMaddeSutDVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
